package com.cftech.cos.uploader.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.cos.uploader.dao.MaterialUploadMapper;
import com.cftech.cos.uploader.model.Material;
import com.cftech.cos.uploader.service.MaterialUploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 素材上传Service
 *
 * @author mubo
 * @date: 2017-05-04 16:35
 */
@Service("uploadService")
public class MaterialUploadServiceImpl extends GenericServiceImpl<Material> implements MaterialUploadService {

    @Autowired
    @Qualifier("materialUploadMapper")
    private MaterialUploadMapper materialUploadMapper;

    @Override
    public GenericDao<Material> getGenericMapper() {
        return materialUploadMapper;
    }

    @Override
    public Map<String, Object> fetchSeaechByNumber(Map<String, Object> params) {
        return materialUploadMapper.fetchSeaechByNumber(params);
    }

    @Override
    public List<Material> fetchSearchByPageVo(Long pId, Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return materialUploadMapper.fetchSearchByPageVo(params);
    }
    @Override
    public int countVo(Long pId, Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("pId", pId);
        return materialUploadMapper.countVo(params);
    }
}