package com.cftech.cms.distributor.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.distributor.model.Distributor;
import com.cftech.cms.distributor.model.DistributorDto;
import com.cftech.cms.distributor.service.DistributorService;
import com.cftech.cms.distributor_area.model.Distributor_area;
import com.cftech.cms.distributor_area.service.Distributor_areaService;
import com.cftech.cms.distributor_type.model.Distributor_type;
import com.cftech.cms.distributor_type.service.Distributor_typeService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/mobile/auth/distributor")
public class MobileDistributorController {

    @Autowired
    private DistributorService distributorService;

    @Autowired
    private Distributor_typeService distributor_typeService;

    @Autowired
    private Distributor_areaService distributor_areaService;


    /**
     * 查所有的经销商
     * @param company 公司名称
     * @return
     */
    @RequestMapping(value = "/showDistributor",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject showDistributor(String company,Long type_id,Long area_id){
        JSONObject jsonObject = new JSONObject();
            try {
                Conds conds = new Conds();
                conds.equal("d.del_flag",0);
                if(StringUtils.isNoneBlank(company)){
                    conds.like("d.company",company);
                }
                if(!StringUtils.isEmpty(String.valueOf(type_id))&&type_id!=null){
                    conds.equal("d.type_id",type_id);
                }
                if(!StringUtils.isEmpty(String.valueOf(area_id))&&area_id!=null){
                    if(area_id!=-1){
                        conds.equal("d.area_id",area_id);
                    }
                }
                Sort sort = new Sort(" convert(d.company using gbk) ", OrderType.ASC);
                List<DistributorDto> distributor = distributorService.selectDistributor(conds,sort,0,0);
                jsonObject.put("data",distributor);
                jsonObject.put("errorNo",0);
            }catch (Exception e){
                e.printStackTrace();
                jsonObject.put("errorNo",1);
            }
        return jsonObject;
    }

    /**
     * 查所有经销商类别
     * @return
     */
    @RequestMapping(value = "/selectType",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject selectType(){
        JSONObject jsonObject = new JSONObject();
        try {
            Conds conds = new Conds();
            conds.equal("del_flag",0);
            Sort sort = new Sort("create_time",OrderType.DESC);
            List<Distributor_type> list = distributor_typeService.fetchSearchByPage(conds,sort,0,0);
            if(list.size()>0&&list!=null){
                jsonObject.put("data",list);
                jsonObject.put("errorNo",0);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * 查所有经销商地区
     * @return
     */
    @RequestMapping(value = "/selectArea",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject selectArea(){
        JSONObject jsonObject = new JSONObject();
        try {
            Conds conds = new Conds();
            conds.equal("del_flag",0);
            Sort sort = new Sort("convert(area_name using gbk)",OrderType.ASC);
            List<Distributor_area> list =distributor_areaService.fetchSearchByPage(conds,sort,0,0);
            if(list.size()>0&&list!=null){
                jsonObject.put("data",list);
                jsonObject.put("errorNo",0);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * 经销商详情
     * @param id 经销商ID
     * @return
     */
    @RequestMapping(value = "/distributorDetail",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject distributorDetail(@RequestParam String id){
        JSONObject jsonObject = new JSONObject();
        try {
            Conds conds = new Conds();
            conds.equal("d.id",id);
            conds.equal("d.del_flag",0);
            //DistributorDto distributorDto = distributorService.selectDistributorDetail(conds);
            List<DistributorDto> list = distributorService.selectDistributor(conds,null,0,0);
            jsonObject .put("errorNo",0);
            jsonObject.put("data",list.get(0));
        }catch(Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
     }

}
