package com.cftech.sys.controller;

import com.cftech.accounts.model.MpAccountsEntity;
import com.cftech.accounts.service.MpAccountsService;
import com.cftech.sys.model.MobileViewlog;
import com.cftech.sys.service.MobileViewlogService;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.sql.Timestamp;
import java.util.Date;

/** 
 * @author 作者 lisw: 
 * @version 创建时间：2016年10月24日 下午1:34:10 
 * 后台日志操作Controller
 */
@Controller
@RequestMapping("/mobile/auth/mobilestaticlog")
public class MobileStaticLogController {
	
	@Autowired
	private MobileViewlogService mobileViewlogService;
	
	@Autowired
	private MpAccountsService mpAccountService;


	@RequestMapping(value="/save",method=RequestMethod.POST)
	@ResponseBody
	public JSONObject save(String params,String appid,HttpServletRequest request){
		//判断请求参数
		System.out.println(params);
		System.out.println(appid);
		JSONObject rtnJson = new JSONObject();
		rtnJson.put("errorNo", 1);
		if(StringUtils.isBlank(appid)){
			return rtnJson;
		}
		Long accountsid = checkappid(appid);
		MobileViewlog mobileViewlog =new MobileViewlog();
		mobileViewlog.setRemoteAddr(com.cftech.core.util.StringUtils.getRemoteAddr(request));
		mobileViewlog.setUserAgent(request.getHeader("user-agent"));
		mobileViewlog.setRequestUri(request.getRequestURI());
		mobileViewlog.setAppid(request.getParameter("appid"));
		mobileViewlog.setCreateDate(new Timestamp(new Date().getTime()));
		mobileViewlog.setParenturl(request.getHeader("REFERER"));
		mobileViewlog.setParams(params);
		mobileViewlog.setAccountsid(accountsid);
		try {
			mobileViewlogService.save(mobileViewlog);
			rtnJson.put("errorNo", 0);
		} catch (Exception e) {
			rtnJson.put("errorNo", 1);
		}
		return rtnJson;
	}
	/**
	 * 根据appid获取accountsid
	 * */
	private Long checkappid(String appid) {
		MpAccountsEntity accountEntity = mpAccountService
				.getMpAccountsAppid(appid);
		if (accountEntity != null) {
			return accountEntity.getId();
		} else {
			return null;
		}
	}
	
	
}
 