package com.cftech.showroom.sdepartment.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 展厅申请部门
 *
 * @author lisw
 * @date: 2019-07-31 15:16
 */
@Data
public class Sdepartment implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    private String number;
    /* 部门名称 */
    @ExportConfig(value = "部门名称", width = 100)
    private String name;
    @ExportConfig(value = "排序值", width = 100)
    private String sort;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Sdepartment() {
        this.delFlag = false;
        this.status = "0";
    }

}