package com.cftech.questionnaire.core.paper.model;


import com.cftech.core.generic.GenericEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.springframework.data.annotation.Transient;

/**
 * Created by liuling on 2017/5/23.
 * 问卷基础类
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class PaperBaseEntity extends GenericEntity {
    private Long id;
    /** 问卷类型 */
    private PaperType paperType;
    /** 问卷标题 */
    private String paperTitle;
    /** 问卷banner */
    private String paperPic;
    /** 问卷分类，链接PaperCategory */
    private Long paperCategory;
    /* 问卷分类名称 */
    @Transient
    private String paperCategoryName;
    /**
     *  问卷问题
     * {
     *     title: 题目标题
     *     type: 题目类型
     *     options: [    选项组合
     *      {
     *          label: '标签名称 ABC 123'
     *          name: '选项名称',
     *          pic: '选项图片链接'
     *      }
     *     ]
     * }
     *  */
    private String questions;

    private String paperTitleEn;
    /** 活动类型 */
    private String activity_type;
    /** 活动ID */
    private Long activity_id;

    private  String act_start_pic;
    private String content_des;
    private  String content_des_en;
    /** 阅读量*/
    private Long reading;
    public PaperBaseEntity() {
        this.delFlag = false;
        this.status = "0";
    }

}
