package com.cftech.member.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cftech.accounts.model.MpAccountsEntity;
import com.cftech.accounts.service.MpAccountsService;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Cond;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.DateFormatUtils;
import com.cftech.core.util.IdcardUtils;
import com.cftech.core.util.StringUtils;
import com.cftech.member.dao.MemberMapper;
import com.cftech.member.model.FanssVO;
import com.cftech.member.model.Member;
import com.cftech.member.model.MemberDto;
import com.cftech.member.model.MemberVO;
import com.cftech.member.service.MemberService;
import com.cftech.mp.fans.model.MpFanssEntity;
import com.cftech.mp.fans.service.MpFanssService;
import com.cftech.workshop.meeting.model.Meeting;
import com.cftech.workshop.workshop.model.Workshop;
import com.cftech.workshop.workshop.service.WorkshopService;
import com.esotericsoftware.minlog.Log;
import com.mchange.v2.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import sun.plugin2.main.client.MessagePassingOneWayJSObject;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * ServiceImpl
 *
 * @author lisw
 * @date: 2017-08-24 17:31
 */
@Service("memberService")
public class MemberServiceImpl extends GenericServiceImpl<Member> implements MemberService {

    @Autowired
    @Qualifier("memberMapper")
    private MemberMapper memberMapper;

    @Autowired
    private MpAccountsService mpAccountsService;

    @Autowired
    private WorkshopService workshopService;

    @Autowired
    private MpFanssService fanssService;

    @Autowired
    private CodingruleUtils codingruleUtils;

    @Override
    public GenericDao<Member> getGenericMapper() {
        return memberMapper;
    }

    @Override
    public List<Member> fetchSearchByPageServer(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return memberMapper.fetchSearchByPageServer(params);
    }

    @Override
    public int countServer(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return memberMapper.countServer(params);
    }

    @Override
    public List<MemberDto> selectmemberDto(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return memberMapper.selectmemberDto(params);
    }

    ;

    @Override
    public int selectmemberDtoCount(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return memberMapper.selectmemberDtoCount(params);
    }

    @Override
    public JSONObject memberFormation(String openid, String appId) {
        JSONObject rtnJson = new JSONObject();
        try {
            if (org.springframework.util.StringUtils.isEmpty(openid)) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "id不能为空");
                return rtnJson;
            }
            MpAccountsEntity accountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            //未注册会员时，填充粉丝信息
            List<MemberVO> memberVOS = memberMapper.memberFormation(openid);
            if (memberVOS == null || memberVOS.size() == 0) {
                MpFanssEntity fanssEntity = fanssService.getWxUser(openid);
                MemberVO member = new MemberVO();
                member.setOpenid(openid);
                member.setMemberName(fanssEntity.getNickname());
                member.setSex(fanssEntity.getSex());
                member.setImageUrl(fanssEntity.getHeadimgurl());
                rtnJson.put("errorNo", "0");
                rtnJson.put("data", member);
            } else {
                rtnJson.put("errorNo", "0");
                rtnJson.put("data", memberVOS.get(0));
            }
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo", "1");
        }
        return rtnJson;
    }

    @Override
    public JSONObject updateMember(MemberVO memberVO) {
        JSONObject rtnJson = new JSONObject();
        try {
            if (StringUtils.isEmpty(memberVO.getMemberName())) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "姓名不能为空");
                return rtnJson;
            }
            if (StringUtils.isEmpty(memberVO.getCardid())) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "身份证不能为空");
                return rtnJson;
            }
            if (StringUtils.isEmpty(memberVO.getPhone())) {
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg", "联系方式不能为空");
                return rtnJson;
            }

            MpAccountsEntity accounts= mpAccountsService.getMpAccountsAppid(memberVO.getAppId());
            List<MemberVO> memberVOS = memberMapper.memberFormation(memberVO.getOpenid());
            if (memberVOS == null || memberVOS.size() == 0) {
                Member member = new Member();
                memberVO.setNumber(codingruleUtils.getNumber(accounts.getId(), Member.class.getName()));
                member.setOpenId(memberVO.getOpenid());
                member.setName(memberVO.getMemberName());
                member.setSex(Long.parseLong(memberVO.getSex()));
                member.setCardid(memberVO.getCardid());
                member.setPhone(memberVO.getPhone());
                member.setImageurl(memberVO.getImageUrl());

                memberMapper.save(member);
                rtnJson.put("errorNo", "0");
                rtnJson.put("errorMsg", "修改成功");
                return rtnJson;
            } else {
                memberMapper.updateMember(memberVO);
                rtnJson.put("errorNo", "0");
                rtnJson.put("errorMsg", "修改成功");
                return rtnJson;
            }
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo", "1");
            rtnJson.put("errorMsg", "系统异常");
        }
        return rtnJson;
    }

    @Override
    public JSONObject fanssChat(String openid, String appId) {
         JSONObject rtnJson = new JSONObject();
         try {
             if (StringUtils.isEmpty(openid)){
                 rtnJson.put("errorNo","1");
                 rtnJson.put("data","openid不能为空");
                 return rtnJson;
             }
             MpAccountsEntity accountsAppid = mpAccountsService.getMpAccountsAppid(appId);
             FanssVO fanssVO = memberMapper.fanssChat(openid);
             if (fanssVO!=null){
                 rtnJson.put("errorNo","0");
                 rtnJson.put("data",fanssVO);
                 return  rtnJson;
             }
         }catch (Exception e){
                e.printStackTrace();
             rtnJson.put("errorNo","1");
         }
         return rtnJson;
    }


    @Override
    public void updateworkshop(Member member, String invitcode) {
        if (member != null) {
            Conds conds1 = new Conds();
            conds1.equal("invitcode", invitcode);
            Sort sort1 = new Sort("create_time", OrderType.DESC);
            List<Workshop> list1 = workshopService.selectworkshop(conds1, sort1, 0, 0);
            if (list1 != null && list1.size() > 0) {
                Workshop workshop = list1.get(0);
                if ( member.getName().equals(workshop.getFirst_name()) && member.getPhone().equals("")) {
                    member.setPhone(workshop.getPhone());
                    memberMapper.save(member); //注册成功会员表里面添加一条数据
                } else {
                    memberMapper.save(member); //注册成功会员表里面添加一条数据
                }
            }
            //把memberuid 插入到预导入名单表里面
            if (StringUtils.isNoneBlank(invitcode)) {
                Conds conds = new Conds();
                conds.equal("invitcode", invitcode);
                Sort sort = new Sort("create_time", OrderType.DESC);
                List<Workshop> list = workshopService.selectworkshop(conds, sort, 0, 0);
                if (list != null && list.size() > 0) {
                    for (Workshop workshop : list) {
                        //workshop.setMember_uid(member.getMember_uid());
                        workshopService.update(workshop);
                    }
                }
            }
        }
    }
}