package com.cftech.report.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.report.model.Report;
import com.cftech.report.dao.ReportMapper;
import com.cftech.report.model.ReportCode;
import com.cftech.report.model.ReportDoctorInfo;
import com.cftech.report.model.ReportPeopleInfo;
import com.cftech.report.service.ReportService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 报表信息ServiceImpl
 *
 * @author Buyj
 * @date: 2020-12-02 11:26
 */
@Service("reportService")
public class ReportServiceImpl extends GenericServiceImpl<Report> implements ReportService {

    @Autowired
    @Qualifier("reportMapper")
    private ReportMapper reportMapper;

    @Override
    public GenericDao<Report> getGenericMapper() {
        return reportMapper;
    }

    @Override
    public List<ReportPeopleInfo> selectReportPeopleInfo(Conds cond, Sort sort) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", cond);
        params.put("sort", sort);
        return reportMapper.selectReportPeopleInfo(params);
    }

    @Override
    public List<ReportCode> selectReportCodeInfo(Conds cond, Sort sort) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", cond);
        params.put("sort", sort);
        return reportMapper.selectReportCodeInfo(params);
    }

    @Override
    public ReportDoctorInfo selectReportDoctorInfo(Conds cond) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", cond);
        return reportMapper.selectReportDoctorInfo(params);
    }
}