package com.cftech.report.job;

import com.cftech.accounts.model.SysJob;
import com.cftech.accounts.service.JobService;
import com.cftech.base.org.model.OrgUnit;
import com.cftech.base.org.model.Qyuser;
import com.cftech.base.org.service.OrgUnitService;
import com.cftech.base.org.service.QyuserService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.SpringContextHolder;
import com.cftech.core.util.SystemConfig;
import com.cftech.report.model.Report;
import com.cftech.report.model.ReportCode;
import com.cftech.report.model.ReportDoctorInfo;
import com.cftech.report.model.ReportPeopleInfo;
import com.cftech.report.service.ReportService;
import com.cftech.shop.qrcode.model.QyUser;
import lombok.extern.slf4j.Slf4j;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 每天凌晨固化报表数据
 */
@Slf4j
public class ReportJob implements Job {

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        boolean isCluster = Boolean.valueOf(SystemConfig.p.getProperty("quartz.isCluster"));
        if (!isCluster) {
            return;
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date today = new Date(System.currentTimeMillis()-(24*60*60*1000));

        ReportService reportService = SpringContextHolder.getBean(ReportService.class);
        OrgUnitService orgUnitService = SpringContextHolder.getBean(OrgUnitService.class);
        QyuserService qyuserService = SpringContextHolder.getBean(QyuserService.class);


        Conds condPeople = new Conds();
        condPeople.equal("DATE_FORMAT(detail.create_time ,'%Y-%m-%d')",format.format(today));
        condPeople.equal("detail.del_flag",0);
        Sort sortPeople = new Sort("detail.create_time", OrderType.DESC);
        //获取报表用户信息
        List<ReportPeopleInfo> listPeople = reportService.selectReportPeopleInfo(condPeople,sortPeople);

        Report report = null;
        if(listPeople.size() > 0){
            for (ReportPeopleInfo reportPeopleInfo : listPeople) {
                report = new Report();
                report.setProductName(reportPeopleInfo.getProductName());
                report.setDrugsNum(reportPeopleInfo.getDrugsNum());
                report.setOrderNumber(reportPeopleInfo.getOrderNumber());
                report.setConsultNumber(reportPeopleInfo.getConsultNumber());
                report.setUserName(reportPeopleInfo.getUserName());
                report.setPhone(reportPeopleInfo.getPhone());
                report.setCfDoctor(reportPeopleInfo.getCfDoctor());
                report.setCfHospital(reportPeopleInfo.getCfHospital());
                report.setFkTime(reportPeopleInfo.getFkTime());
                report.setFhTime(reportPeopleInfo.getFhTime());
                report.setSjTime(reportPeopleInfo.getSjTime());
                //根据openId获取扫码记录 只获取医生和组织二维码
                Conds condCode = new Conds();
                condCode.equal("record.openid",reportPeopleInfo.getOpenId());
                condCode.in("record.type",new String[]{"3","4"});
                Sort sortCode = new Sort("record.create_time",OrderType.DESC);
                List<ReportCode> listCode = reportService.selectReportCodeInfo(condCode,sortCode);
                if(listCode.size()>0){
                    if(listCode.get(0).getType().equals("3")){
                        //二维码类型为医生 根据绑定的医生人员ID查医生信息
                        Conds condDoctor = new Conds();
                        condDoctor.equal("qyuser.id",listCode.get(0).getBindId());
                        condDoctor.equal("qyuser.del_flag","0");
                        ReportDoctorInfo reportDoctorInfo = reportService.selectReportDoctorInfo(condDoctor);
                        if(reportDoctorInfo != null){
                            report.setDoctorName(reportDoctorInfo.getUserName());
                            report.setDoctorPhone(reportDoctorInfo.getUserPhone());
                            report.setDoctorTitle("医生");
                            report.setSex(reportDoctorInfo.getGender());

                            String orgParentIds = reportDoctorInfo.getOrgParentIds();
                            String[] orgParentIdArray = orgParentIds.split(",");
                            String regionOrgIds = SystemConfig.p.getProperty("REGION_LONG_ID");
                            if (orgParentIds.contains(regionOrgIds) && orgParentIdArray.length > regionOrgIds.split(",").length){
                                //若果医生组织id在区域组织下面 则根据大区长编码获取下面所有组织信息
                                String areIds = regionOrgIds + regionOrgIds.split(",")[4];
                                Conds condOrg = new Conds();
                                condOrg.rightLike("t.parent_ids",areIds);
                                Sort sortOrg = new Sort("t.parent_id",OrderType.ASC);
                                List<OrgUnit> orgUnits = orgUnitService.fetchSearchByPage(0L,condOrg,sortOrg,0,0);
                                if (orgUnits.size() > 0){
                                    //若根据大区长编码查出数据 循环
                                    for (OrgUnit orgUnit : orgUnits){
                                        int level = orgUnit.getParentIds().split(",").length;
                                        if (level == 4){
                                            // 大区
                                            report.setRegion(orgUnit.getOrgName());
                                        }else if (level == 5){
                                            // 省
                                            report.setProvince(orgUnit.getOrgName());
                                        }else if (level == 6) {
                                            // 市
                                            report.setCity(orgUnit.getOrgName());
                                        }else if (level == 7) {
                                            //医院
                                            report.setHospital(orgUnit.getOrgName());
                                            // 根据医院组织ID 查找医院下面的销售代表
                                            Conds condDepartment = new Conds();
                                            condDepartment.equal("t.org_id",orgUnit.getId());
                                            List<Qyuser> listUser = qyuserService.fetchSearchByPage(0L,condDepartment,null,0,0);
                                            StringBuffer sb = new StringBuffer();
                                            if(listUser.size() > 0){
                                                for (Qyuser qyuser : listUser) {
                                                    sb.append(qyuser.getName() + ",");
                                                }
                                            }
                                            report.setSalesRepresent(sb.toString());
                                        }else if (level == 8) {
                                            //科室
                                            report.setDepartment(orgUnit.getOrgName());
                                        }
                                    }

                                }
                            }
                        }
                    }else{
                        //二维码类型为组织 根据绑定的组织ID获取对应组织信息
                        OrgUnit orgUnitObj = orgUnitService.fetchById(listCode.get(0).getBindId());
                        if(orgUnitObj != null){
                            String orgParentIds = orgUnitObj.getParentIds();
                            String[] orgParentIdArray = orgParentIds.split(",");
                            String regionOrgIds = SystemConfig.p.getProperty("REGION_LONG_ID");
                            if (orgParentIds.contains(regionOrgIds) && orgParentIdArray.length > regionOrgIds.split(",").length){
                                //若果医生组织id在区域组织下面 则根据大区长编码获取下面所有组织信息
                                String areIds = regionOrgIds + orgParentIdArray[3];
                                Conds condOrg = new Conds();
                                condOrg.rightLike("t.parent_ids",areIds);
                                Sort sortOrg = new Sort("t.parent_id",OrderType.ASC);
                                List<OrgUnit> orgUnits = orgUnitService.fetchSearchByPage(0L,condOrg,sortOrg,0,0);
                                if (orgUnits.size() > 0){
                                    //若根据大区长编码查出数据 循环
                                    for (OrgUnit orgUnit : orgUnits){
                                        int level = orgUnit.getParentIds().split(",").length;
                                        if (level == 4){
                                            // 大区
                                            report.setRegion(orgUnit.getOrgName());
                                        }else if (level == 5){
                                            // 省
                                            report.setProvince(orgUnit.getOrgName());
                                        }else if (level == 6) {
                                            // 市
                                            report.setCity(orgUnit.getOrgName());
                                        }else if (level == 7) {
                                            //医院
                                            report.setHospital(orgUnit.getOrgName());
                                            // 根据医院组织ID 查找医院下面的销售代表
                                            Conds condDepartment = new Conds();
                                            condDepartment.equal("t.org_id",orgUnit.getId());
                                            List<Qyuser> listUser = qyuserService.fetchSearchByPage(0L,condDepartment,null,0,0);
                                            StringBuffer sb = new StringBuffer();
                                            if(listUser.size() > 0){
                                                for (int i = 0; i < listUser.size(); i++) {
                                                    Qyuser qyUser = listUser.get(i);
                                                    if(i == listUser.size()-1){
                                                        sb.append(qyUser.getName() );
                                                    }else{
                                                        sb.append(qyUser.getName() + ",");
                                                    }

                                                }
                                            }
                                            report.setSalesRepresent(sb.toString());
                                        }else if (level == 8) {
                                            //科室
                                            report.setDepartment(orgUnit.getOrgName());
                                        }
                                    }

                                }
                            }
                        }
                        //查找医生信息
                        Conds conds = new Conds();
                        conds.equal("record.openid",reportPeopleInfo.getOpenId());
                        conds.in("record.type",new String[]{"3"});
                        Sort sort = new Sort("record.create_time",OrderType.DESC);
                        List<ReportCode> list = reportService.selectReportCodeInfo(conds,sort);
                        if(list.size() > 0){
                            Conds condDoctor = new Conds();
                            condDoctor.equal("qyuser.id",listCode.get(0).getBindId());
                            condDoctor.equal("qyuser.del_flag","0");
                            ReportDoctorInfo reportDoctorInfo = reportService.selectReportDoctorInfo(condDoctor);
                            if (reportDoctorInfo != null){
                                report.setDoctorName(reportDoctorInfo.getUserName());
                                report.setDoctorPhone(reportDoctorInfo.getUserPhone());
                                report.setDoctorTitle("医生");
                                report.setSex(reportDoctorInfo.getGender());
                            }
                        }

                    }

                }

                //新增报表记录
                reportService.save(report);

            }
        }



        //获得明细数据
        JobDataMap jobInfo = context.getJobDetail().getJobDataMap();
        //这个也是ID主键
        String id = jobInfo.get("uid") == null ? "" : jobInfo.getString("uid");
        log.info("任务ID：" + id);

        //执行更新操作
        if (context.getNextFireTime() != null) {
            log.info("报表数据接口调用：下次执行时间=====" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(context.getNextFireTime()) + "==============");
        } else {
            JobService jobService = SpringContextHolder.getBean(JobService.class);
            SysJob sysJob = new SysJob();
            sysJob.setJobuid(id);
            sysJob.setStatus("0");
            jobService.updateStatus(sysJob);
            log.info("报表数据接口调用任务，已执行完成！");
        }
    }

    public static void main(String[] args) {
        String str = "0,1,5,36,40,41,";
        String[] arry = str.split(",");
        if(str.contains("0,1,5,")){
            System.out.println(arry.length);
        }
    }

    public Report setOrgUnitInfo (String orgParentId , Report report){

        return report;
    }
}
