package com.cftech.activity.record.service.impl;

import com.cftech.activity.record.dao.OilRecordMapper;
import com.cftech.activity.record.model.OilRecord;
import com.cftech.activity.record.service.OilRecordService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.member.dao.MemberMapper;
import com.cftech.member.model.Member;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * ServiceImpl
 *
 * @author lisw
 * @date: 2017-10-12 17:32
 */
@Service("oilRecordService")
public class OilRecordServiceImpl extends GenericServiceImpl<OilRecord> implements OilRecordService {

    @Autowired
    @Qualifier("oilRecordMapper")
    private OilRecordMapper oilRecordMapper;

    @Autowired
    private MemberMapper memberMapper;

    @Override
    public GenericDao<OilRecord> getGenericMapper() {
        return oilRecordMapper;
    }

    @Override
    public boolean saveTran(OilRecord oilRecord, Member member) {
        oilRecordMapper.save(oilRecord);
        memberMapper.update(member);
        return true;
    }
}