package com.cftech.workshop.agenda.service.impl;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.workshop.agenda.dao.AgendascoreMapper;

import com.cftech.workshop.agenda.model.Agendascore;
import com.cftech.workshop.agenda.service.AgendascoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.util.HtmlUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2018-07-14 16:10
 */
@Service("agendascoreService")
public class AgendascoreServiceImpl extends GenericServiceImpl<Agendascore> implements AgendascoreService {

    @Autowired
    @Qualifier("agendascoreMapper")
    private AgendascoreMapper agendascoreMapper;


    @Override
    public GenericDao<Agendascore> getGenericMapper() {
        return agendascoreMapper;
    }



    @Override
    public void addagendascore(String scor){
        String str = HtmlUtils.htmlUnescape(scor);
        JSONObject object = JSONObject.parseObject(str);
        JSONArray jsonArray = JSON.parseArray(object.getString("scroe"));
        for(int i=0;i<jsonArray.size();i++){
            JSONObject json = jsonArray.getJSONObject(i);
            Agendascore agendascore1 = new Agendascore();
            Conds conds = new Conds();
            conds.equal("agenda_id",Long.valueOf(json.getString("agenda_id")));
            conds.equal("member_uid",object.getString("member_uid"));
            Map<String, Object> params = new HashMap<String, Object>();
            params.put("conds", conds);
            List<Agendascore> list = agendascoreMapper.fetchSearchByPage(params);
            if(list.size()>0){
                for(Agendascore agendascore :list){
                    agendascore1.setId(agendascore.getId());
                    agendascore1.setAgenda_id(Long.valueOf(json.getString("agenda_id")));
                    agendascore1.setScore(Long.valueOf(json.getString("scroe")));
                    agendascore1.setAccountsId(Long.valueOf(object.getString("accountsid")));
                    agendascore1.setMember_uid(object.getString("member_uid"));
                    agendascoreMapper.update(agendascore1);
                }
            }else {
                agendascore1.setAgenda_id(Long.valueOf(json.getString("agenda_id")));
                agendascore1.setScore(Long.valueOf(json.getString("scroe")));
                agendascore1.setAccountsId(Long.valueOf(object.getString("accountsid")));
                agendascore1.setMember_uid(object.getString("member_uid"));
                agendascoreMapper.save(agendascore1);
            }
        }
    }

}