package com.cftech.showroom.appform.model;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @version V1.0
 * @Package com.cftech.showroom.appform.model
 * @Name cftech-platform
 * @Description: TODO 评价表
 * @date 2020/6/27
 */
@Data
public class ShowroomEvaluate implements Serializable {

    /**
     * 主键
     */
    private String id;

    /**
     * 申请单ID
     */
    private Long showroomId;

    /**
     * 申请单号
     */
    private String number;

    /**
     * 用户openid
     */
    private String openid;

    /**
     * 对品牌及技术专长的了解评分
     */
    private Integer brand;

    /**
     * 媒体设备评分
     */
    private Integer mediaDevice;

    /**
     * 讲解专业，内容丰富评分
     */
    private Integer explainMajor;

    /**
     * 着装评分
     */
    private Integer clothing;

    /**
     * 建议或反馈
     */
    private String proposal;

    /**
     * 删除标识
     */
    private boolean delFlag;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 更新人
     */
    private Long updateBy;

    public ShowroomEvaluate() {
        this.delFlag = false;
    }


}
