package com.cftech.questionnaire.core.paper.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.util.StringUtils;
import com.cftech.questionnaire.core.paper.model.PaperBaseEntity;
import com.cftech.questionnaire.core.paper.service.PaperService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 问卷浏览接口
 * Created by Ago on 2018/10/10.
 */
@RestController
@RequestMapping(value = "/mobile/auth/paper")
public class MobilePaperController {
    @Autowired
    private PaperService paperService;


    /**
     * 问卷浏览
     * @param id 问卷ID
     * @return
     */
    @RequestMapping(value = "/paperread",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE )
    public JSONObject paperread(Long id){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(id))){
                PaperBaseEntity paperBaseEntity = paperService.fetchById(id);
                if(paperBaseEntity!=null){
                    paperBaseEntity.setReading(paperBaseEntity.getReading()+1);
                    boolean flag = paperService.update(paperBaseEntity);
                    if(flag){
                        jsonObject.put("errorNo",0);
                    }
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }
}
