package com.cftech.sys.controller;

import com.cftech.sys.model.User;
import com.cftech.sys.model.UserRole;
import com.cftech.sys.security.UserUtils;
import com.cftech.sys.service.PermissionService;
import com.cftech.sys.service.RoleService;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 公共视图控制器
 * 
 **/
@Controller
@RequestMapping("/a")
public class CommonController {
	
	@Autowired
	private PermissionService permissionService;

	@Autowired
	private RoleService roleService;

	
	
    /**
     * 首页
     * 
     * @param request
     * @return
     */
    @RequestMapping("index")
	public String index(HttpServletRequest request, Model model) {
		Subject subject = SecurityUtils.getSubject();

		User currentUser = UserUtils.getUser();

			String roleids = "";
			List<UserRole> userRole = roleService.selectRolesByUserId(currentUser.getId());
		if (userRole.size() > 0) {
			for (int i = 0; i < userRole.size(); i++) {
				if (i == userRole.size() - 1) {
					roleids += userRole.get(i).getRoleId();
				} else {
					roleids += userRole.get(i).getRoleId() + ",";
				}
			}
			if (StringUtils.isNotBlank(roleids)) {
				model.addAttribute("permission", permissionService.getMenuByRoles(roleids));
			}

			//获得当前账号

			request.getSession().setAttribute("isshow", "2");//不显示，首页报表图
			return "index";
		} else {
			return "welcome";
		}
	}

	@RequestMapping("showpage")
    public String showpage(HttpServletRequest request,Model model)
    {

    	User currentUser = UserUtils.getUser();
    	
    	//String roleids = currentUser.getRoles();
    	String roleids= "";
    	List<UserRole> userRole = roleService.selectRolesByUserId(currentUser.getId());
    	for(int i =0;i<userRole.size();i++){
    		if(i==userRole.size()-1){
    			roleids+=userRole.get(i).getRoleId();
    		}else{
    			roleids+=userRole.get(i).getRoleId()+",";
    		}
    	}
    	if(StringUtils.isNotBlank(roleids))
    	{
    		model.addAttribute("permission",permissionService.getMenuByRoles(roleids));
    	}
    	//获得当前账号 

    	//调用微信接口获得 关注数据 详情 
        return "index";
    }
    

}