package com.cftech.cms.exhibi.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.exhibi.model.Exhibi;
import com.cftech.cms.exhibi.service.ExhibiService;
import com.cftech.collection.service.CollectionService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.like.model.Like;
import com.cftech.like.service.LikeService;
import com.esotericsoftware.minlog.Log;
import lombok.extern.slf4j.Slf4j;
import org.owasp.esapi.ESAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * Created by byj on 2018/6/14.
 * 展会选择手机端接口
 */
@Slf4j
@RestController
@RequestMapping("/mobile/auth/exhibi")
public class MobileExhibiController {

    @Autowired
    private ExhibiService exhibiService;

    @Autowired
    private LikeService likeService;

    @Autowired
    private CollectionService collectionService;


    /**
     *
     * @param exhibi_type  前端页面传来展会类型exhibi_type  0:汽车展会  1：工业展会
     * @param exhibi_title  前端页面搜索展会的名称
     * @return
     */
    @RequestMapping(value = "/searchtypeid", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject searchtypeid(String exhibi_type , String exhibi_title, Long accounts_id){
        JSONObject jsonObject = new JSONObject();
        if(StringUtils.isNotBlank(exhibi_type)){
            try {
                Conds conds = new Conds();
                conds.equal("accounts_id",accounts_id);
                conds.equal("del_flag",0);
                if(StringUtils.isNotBlank(exhibi_title)){
                    conds.like("exhibi_title",exhibi_title);
                }
                conds.equal("exhibi_type",exhibi_type);
                Sort sort = new Sort("update_time", OrderType.DESC);
                List<Exhibi> list = exhibiService.fetchSearchByPage(conds,sort,0,0);
                jsonObject.put("errorNo",0);
                jsonObject.put("data",list);
            } catch (Exception e) {
                e.printStackTrace();
                jsonObject.put("errorNo",1);
            }
        }
        return  jsonObject;
    }

    /**
     * 获得展会详细信息
     * @param openid  前端传来openid
     * @param id  前端传来展会id
     * @param type_id 展会类型id
     * @return
     */
    @RequestMapping(value = "/exhibiid", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject exhibiid(String openid, String id , String type_id , HttpServletRequest request, Long accounts_id){
        JSONObject jsonObject = new JSONObject();

        if(StringUtils.isNotBlank(openid)&&StringUtils.isNotBlank(id)){
            try {

                Exhibi exhibi = exhibiService.fetchById(id);
                exhibiService.updatebrowse(openid,id,accounts_id,request ,exhibi);

                jsonObject.put("errorNo",0);
                jsonObject.put("exhibi_title",exhibi.getExhibi_title());
                jsonObject.put("exhibi_title_en",exhibi.getExhibi_title_en());

                jsonObject.put("content_exhibi",ESAPI.encoder().decodeForHTML(exhibi.getContent_exhibi()));
                jsonObject.put("content_exhibi_en",ESAPI.encoder().decodeForHTML(exhibi.getContent_exhibi_en()));
                jsonObject.put("reading",exhibi.getReading());
                jsonObject.put("fabulous",exhibi.getFabulous());
                jsonObject.put("create_time",exhibi.getCreateTime());
                jsonObject.put("exhibi_number",exhibi.getExhibi_number());
                //是否显示展品信息
                jsonObject.put("show_exhibits",exhibi.getShow_exhibits());
                //是否显示相关问询
                jsonObject.put("show_inquiries",exhibi.getShow_inquiries());
                //是否显示样本资料
                jsonObject.put("show_sample",exhibi.getShow_sample());
                //判断是否点赞
                Conds condsLike = new Conds();
                condsLike.equal("user_id",openid);
                condsLike.equal("entity_id",id);
                condsLike.equal("module_type",0);
                condsLike.equal("type",0);
                condsLike.equal("del_flag",0);
                int count = likeService.count(condsLike);
                if(count>0){  //count>0  已经点赞
                jsonObject.put("isfabulous",0);  // isfabulous  0:已经点赞   1:未点赞
                }else{
                 jsonObject.put("isfabulous",1);
                }
                //判断是否搜藏
                Conds condsCollect = new Conds();
                condsCollect.equal("module_type",4);
                condsCollect.equal("entity_id",id);
                condsCollect.equal("user_id",openid);
                condsCollect.equal("type",0);
                condsCollect.equal("del_flag",0);
                int countCollect = collectionService.count(condsCollect);
                if(countCollect>0){ //countCollect>0  已经搜藏
                    jsonObject.put("iscollections",0);  //  collections  0:已经搜藏  1：未搜藏
                }else{
                    jsonObject.put("iscollections",1);
                }

            }catch (Exception e){
                e.printStackTrace();
                jsonObject.put("errorNo",1);
            }
        }
        return jsonObject;
    }

    /**
     * 判断是否发布或者删除
     * @param id 分类下面的展会的id
     * @return
     */
    @RequestMapping(value = "/isrelease" ,method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject isrelease(Long id){
        JSONObject jsonObject = new JSONObject();
        //查看展会是否发布
       try{
           if(StringUtils.isNoneBlank(String.valueOf(id))){
               Exhibi exhibi = exhibiService.fetchById(id);
               if(exhibi!=null){
                   if(exhibi.getReleas().equals("1")||exhibi.isDelFlag()){ //未发布或已删除
                        jsonObject.put("errorNo",0);
                   }
               }else{
                   jsonObject.put("errorNo",2);
               }
           }else{
               jsonObject.put("errorNo",2);
           }
       }catch (Exception e){
           e.printStackTrace();
           jsonObject.put("errorNo",1);
       }
        return jsonObject;
    }

    /**
     *  取消发布
     * @param exhibi_type 前端页面传来展会类型exhibi_type  0:汽车展会  1：工业展会
     * @param id 分类下面的展会的id
     * @return
     */
    @RequestMapping(value = "/norelease",method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE )
    public JSONObject norelease(String exhibi_type , Long id){
        JSONObject jsonObject = new JSONObject();
        try {
            Conds conds = new Conds();
            conds.equal("exhibi_type",exhibi_type);
            conds.equal("releas","0"); //发布 0:发布  1:未发布
            conds.equal("id" , id);
            int relea = exhibiService.count(conds);
            if(relea>0){
                Exhibi exhibi = new Exhibi();
                exhibi.setId(id);
                exhibi.setReleas("1");
                boolean b = exhibiService.update(exhibi);
                if(b==true){
                    jsonObject.put("errorNo",1); //成功取消发布
                    Log.info("取消发布");
                }
            }else{ //该展会还没有发布则不可以取消发布
                jsonObject.put("errorNo",0);
                Log.info("该展会还没有发布则不可以取消发布");
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return jsonObject;
    }

}
