package com.cftech.module.activity.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.module.activity.core.model.ActivityBaseEntity;
import com.cftech.module.activity.core.service.ActivityBaseService;
import com.cftech.module.activity.core.utils.ActivityBaseRedisAPI;
import com.cftech.module.activity.core.utils.ActivityKeys;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by liuling on 2017/4/18.
 */
public abstract class ActivityBaseServiceImpl<T extends ActivityBaseEntity> extends GenericServiceImpl<T> implements ActivityBaseService<T> {

    @Autowired
    protected ActivityBaseRedisAPI<T> redisAPI;
    /**
     * 开始活动
     * @param t
     * @return
     */
    @Override
    public boolean startActivity(T t) {
        ActivityKeys keys = redisAPI.init(t);
        if (redisAPI.startActivity(t, keys)) {
            t.setStatus("1");
            update(t);
            return true;
        } else {
            return false;
        }
    }

    @Override
    public JSONObject play(String openId, T t) {
        ActivityKeys keys = redisAPI.init(t);
        return redisAPI.play(openId, t, keys);
    }

    /**
     * 结束活动
     * @param t
     */
    @Override
    public void endActivity(T t) {
        ActivityKeys keys = redisAPI.init(t);
        redisAPI.endActivity(t, keys);
        t.setStatus("2");
        update(t);
    }
}
