package com.cftech.module.activity.core.model;

import com.cftech.core.generic.GenericEntity;
import com.cftech.module.activity.core.enums.ProbabilityMethod;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.Date;

/**
 * Created by liuling on 2017/4/18.
 * 活动的基础类
 */
@Data
@NoArgsConstructor
@ToString
public class ActivityBaseEntity extends GenericEntity {

    /**
     * 所属的账号
     */
    protected Long accountsId;
    //活动名称
    protected String title;
    //触发关键词
    protected String keywords;
    //活动说明
    protected String explain;
    //中奖提示
    protected String wintips;
    //活动开始时间
    protected Date startTime;
    //活动结束时间
    protected Date endTime;
    //重复抽奖回复
    protected String drawAgainReply;

    //超过每天抽奖次数提示
    protected  String drawAgainDayReply;
    //活动开始图片
    protected String actStartPic;
    //活动结束
    protected String endTitle;
    //活动结束说明
    protected String endExplain;
    //活动开始图片
    protected String actEndPic;

    /**
     * 奖项JSON格式
     * [
     * {
     *     code: first, -- redis需要存储
     *     name: 一等奖,
     *     desc: 奖品内容,
     *     type: 奖品类型,
     *     qty: 奖品数量,
     *     amount: 奖品金额,
     *     probability: 0.4 如果使用概率算法不是normal，则不需要填写这个值
     * }
     * ]
     */
    protected String prizes;

    /**
     * 使用的概率算法
     */
    protected ProbabilityMethod probabilityMethod;
    //参与人数预估
    protected int attendPersonNum;
    //每人抽奖次数
    protected int perPersonDrawNum;
    //每人可中奖次数
    protected int perPersonCanPrize;
    //每天可抽奖次数
    protected int perDayDrawNum;
    //显示奖品数量
    protected boolean showPrizesNum;
    //注册后才能参与
    protected boolean needRegister;
    //活动状态,0 未开始，1 已开始，2 结束
    protected String status;

    /**
     * 英文对应属性
     */
    //活动说明英文
    protected  String explainEn;

    //活动说明英文
    protected  String titleEn;

    //中奖提示英文
    protected  String wintipsEn;

    //超过总抽奖次数英文提示
    protected  String drawAgainReplyEn;

    //超过每天抽奖次数英文提示
    protected  String drawAgainDayReplyEn;

    //活动结束title英文提示
    protected  String endTitleEn;

    //活动结束说明英文提示
    protected  String endExplainEn;

    //
    private Long meetingId;

}
