package com.cftech.workshop.sample.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.workshop.sample.model.Sample;
import com.cftech.workshop.sample.service.SampleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 会议资料接口
 * Created by Ago on 2018/7/17.
 */
@RestController
@RequestMapping(value = "/mobile/auth/sample")
public class MobileSampleController {

    @Autowired
    private SampleService sampleService;

    /**
     * 会议资料
     * @param meetingId 研讨会的ID
     * @param page
     * @param pagesize
     * @param sample_title 会议资料标题
     * @type 0:中文  1：英文
     * @return
     */
    @RequestMapping(value = "/getsaple",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getsaple(Long meetingId,int page,int pagesize,String type,String sample_title,Long accountsId){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(meetingId))){
                Conds conds = new Conds();
                conds.equal("workshop_id",meetingId);
                conds.equal("del_flag",0);
                if(type.equals("")){ //中文
                    if(StringUtils.isNoneBlank(sample_title)){
                        conds.like("sample_title",sample_title);
                    }
                }else{  //英文
                    if(StringUtils.isNoneBlank(sample_title)){
                        conds.like("sample_title_en",sample_title);
                    }
                }
                Sort sort = new Sort("sort", OrderType.ASC);
                List<Sample> list = sampleService.fetchSearchByPage(conds,sort,page*pagesize,pagesize);
                if(list!=null && list.size()>0){
                    jsonObject.put("errorNo",0);
                    jsonObject.put("data",list);
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * 会议资料详情接口
     * @param id 会议资料实体ID
     * @param memberUid 会员名称
     * @return
     */
    @RequestMapping(value = "/getsampledetails",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getsampledetails(Long id, String memberUid,Long accountsId){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(id))){
                Sample sample = sampleService.updatesampleclicks(memberUid,id,accountsId);
                if(sample!=null){
                    jsonObject.put("errorNo",0);
                    sample.setContent_sample(HtmlUtils.htmlUnescape(sample.getContent_sample()));
                    sample.setContent_sample_en(HtmlUtils.htmlUnescape(sample.getContent_sample_en()));
                    jsonObject.put("data",sample);
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }
}
