package com.cftech.showroom.relevanter.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 展厅申请相关人
 *
 * @author lisw
 * @date: 2019-08-01 13:36
 */
@Data
public class Relevanter implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    private String number;
    /* 相关人员姓名 */
    @ExportConfig(value = "接收人姓名", width = 100)
    private String name;
    /* 相关人员邮箱 */
    @ExportConfig(value = "接收人邮箱", width = 100)
    private String email;

    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    @ExportConfig(value = "是否是展厅管理员（0：是 1：否）", width = 100)
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;
    @ExportConfig(value = "排序值", width = 100)
    private String sort;


    public Relevanter() {
        this.delFlag = false;
        this.status = "0";
    }

}