package com.cftech.common.marketing.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 市场部领导配置
 *
 * @author faye
 * @date: 2019-08-14 17:24
 */
@Data
public class Marketing implements Serializable {

    /* 主键id */
    private Long id;
    /* 邮箱 */
    @ExportConfig(value = "邮箱", width = 100)
    private String email;
    /* 姓名 */
    @ExportConfig(value = "姓名", width = 100)
    private String name;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    private Long typeform;

    public Marketing() {
        this.delFlag = false;
        this.status = "0";
    }

}