package com.cftech.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by lisw on 2017/9/28.
 * 接口调用类
 */
@Slf4j
public class RestFulUtils {

    //获取会员标签数据接口
    private static String searchMemberTagsUrl = "http://180.169.184.109:8889/getTags";

    //DMS接口前缀
    private static String prefix = "http://180.169.184.107:8080/INFO_GMS_WEB/rest/";

    //获取会员积分记录接口
    private static String searchMemberIntegralUrl = prefix + "integralRecord";

    //积分兑换几口
    private static String addIntegerRecord = "http://180.169.184.107:8080/INFO_GMS_WEB/rest/addRedeem";

    //会员兑换密码校验
    private static String validPasswordUrl = "http://180.169.184.107:8080/INFO_GMS_WEB/rest/checkPassword";

    //工单列表接口
    private static String findWorkOrderList = "http://180.169.184.107:8080/INFO_GMS_WEB/rest/findWorkOrderList";

    //工单进度接口
    private static String findWorkOrderSchdule = "http://180.169.184.107:8080/INFO_GMS_WEB/rest/findWorkOrderSchedule";

    //工单详情接口
    private static String findWorkOrderDetail = "http://180.169.184.107:8080/INFO_GMS_WEB/rest/findWorkOrderDetails";

    //查询新车接口
    private static final String findNewCarUrl = "http://180.169.184.107:8080/INFO_GMS_WEB/rest/findNewCar";

    //查询新车购车进度
    private static final String findNewCarDetailUrl = "http://180.169.184.107:8080/INFO_GMS_WEB/rest/newCarDetail";

    //查询储值记录
    private static final String findMoneyRecordUrl = "http://180.169.184.107:8080/INFO_GMS_WEB/rest/moneyRecord";

    //查询会员车辆信息
    private static final String findMemberCarUrl = "http://180.169.184.107:8080/INFO_GMS_WEB/rest/findMemberCar";

    //提交预约单
    private static final String submitReserveOrderUrl = "http://180.169.184.107:8080/INFO_GMS_WEB/rest/subOrder";

    //根据会员编码获取会员标签数据接口
    public static String searchMemberTags(String mCard) {
        String newUrl = searchMemberTagsUrl + "?mCard=" + mCard;
        String res = "";
        try {
            res = OKHttpUtils.getJSON(newUrl);
            JSON.parseObject(res);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return res;
    }


    /**
     * 新车查询
     *
     * @param name   人员姓名
     * @param idCard 身份证号或组织机构代码
     */
    public static String findNewCar(String name, String idCard) {
        String res = "";
        try {
            Map<String, Object> params = new HashMap<String, Object>();
            params.put("name", name);
            params.put("idCard", idCard);
            res = OKHttpUtils.sendPost(findNewCarUrl, params);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("新车查询接口调用异常:" + e.getMessage());
        }
        return res;
    }

    /**
     * 新车购车进度查询
     *
     * @param name    人员姓名
     * @param idCard  身份证号或组织机构代码
     * @param mobile  电话
     * @param id      订单号
     * @param storeNo 门店编码
     */
    public static String findNewCarDetail(String name, String idCard, String mobile, String id, String storeNo) {
        String res = "";
        try {
            Map<String, Object> params = new HashMap<String, Object>();
            params.put("name", name);
            params.put("idCard", idCard);
            params.put("mobile", mobile);
            params.put("id", id);
            params.put("storeNo", storeNo);
            res = OKHttpUtils.sendPost(findNewCarDetailUrl, params);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("新车查询接口调用异常:" + e.getMessage());
        }
        return res;
    }



    //根据会员编码获取会员积分流水记录
    public static String getSearchMemberIntegralUrl(String mCard, int page, int pageSize) throws NoSuchMethodException {
        page = page + 1;
        try {
            Map<String, Object> params = new HashMap<String, Object>();
            params.put("mCard", mCard);
            params.put("page", page);
            params.put("pageSize", pageSize);
            String res = OKHttpUtils.sendPost(searchMemberIntegralUrl, params);
            return res;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

    }

    //添加会员兑换记录
    public static String addIntegerRecord(String mcard, String storeNo, String name, String idCard,
                                          String mobile, Long commodityId, String commodityName,
                                          String integralType, String integralTotal, String commodityCode) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("mCard", mcard);
        params.put("storeNo", storeNo);
        params.put("name", name);
        params.put("idCard", idCard);
        params.put("mobile", mobile);
        params.put("commodityId", commodityId);
        params.put("commodityName", commodityName);
        params.put("integralType", integralType);
        params.put("integralTotal",integralTotal);
        params.put("commodityCode", commodityCode);
        String res = OKHttpUtils.sendPost(addIntegerRecord, params);
        return res;
    }



    //校验密码
    public static boolean validPassword(String mcard, String password, String storeNo) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("mCard", mcard);
        params.put("password", password);
        params.put("storeNo", storeNo);
        String res = OKHttpUtils.sendPost(validPasswordUrl, params);
        if (StringUtils.isNotBlank(res)) {
            JSONObject rtnJson = JSON.parseObject(res);
            if (rtnJson.getString("errorNo").equals("0")) {
                return true;
            } else {
                return false;
            }
        }
        return false;
    }

    //工单列表
    public static String findWorkOrderList(String cars, int page, int pageSize, String phone) {
        page = page + 1;
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("cars", cars);
        params.put("page", page);
        params.put("mobile", phone);
        params.put("pageSize", pageSize);
        String res = OKHttpUtils.sendPost(findWorkOrderList, params);
        return res;
    }

    //工单进度
    public static String findWorkOrderSchdule(String storeNo, String id) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("storeNo", storeNo);
        params.put("id", id);
        String res = OKHttpUtils.sendPost(findWorkOrderSchdule, params);
        return res;
    }

    //工单详情
    public static String findWorkOrderDetail(String storeNo, String id,int page,int pageSize) {
        page=page+1;
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("page", page);
        params.put("pageSize", pageSize);
        params.put("storeNo", storeNo);
        params.put("id", id);
        String res = OKHttpUtils.sendPost(findWorkOrderDetail, params);
        return res;
    }

    //储值记录
    public static String findMoneyRecord(String mCard, int page, int pageSize) {
        try {
            Map<String, Object> params = new HashMap<String, Object>();
            params.put("mCard", mCard);
            params.put("page", page + 1);
            params.put("pageSize", pageSize);
            String res = OKHttpUtils.sendPost(findMoneyRecordUrl, params);
            return res;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    //查询会员车辆信息
    public static String getFindMemberCarList(String name, String mobile, String idCard) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("idCard", idCard);
        params.put("mobile", mobile);
        String res = OKHttpUtils.sendPost(findMemberCarUrl, params);
        return res;
    }

    //提交工单
    public static String submitReserveOrder(String mCard, String cars, String name, String idCard, String mobile, String storeNo,
                                            String orderSet, String subDate, String subStartTime, String subEndTime) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("mCard", mCard==null?"":mCard);
        params.put("cars", cars);
        params.put("name", name);
        params.put("idCard", idCard==null?"":idCard);
        params.put("mobile", mobile);
        params.put("storeNo", storeNo);
        params.put("orderSet", orderSet);
        params.put("subDate", subDate);
        params.put("subStartTime", subStartTime);
        params.put("subEndTime", subEndTime);
        String res = OKHttpUtils.sendPost(submitReserveOrderUrl, params);
        log.info("提交预约单:" + res);
        return res;
    }
}
