package com.cftech.order.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.order.service.OrderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * @author ：licc
 * @date ：Created in 2020/10/30 15:40
 * @description：
 */
@Slf4j
@RestController
@CrossOrigin
@RequestMapping("mobile/auth/order")
public class MobileOrderController {
    @Autowired
    private OrderService orderService;
    /**
     * @Author Licc
     * @Description  待确认订单
     * @Date 15:43 2020/10/30
     * @Param  
     * @return 
     **/
    @RequestMapping(value = "/confirm",method = {RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject confirm(String openid, Long status,Long id){
        return orderService.confirm(openid,status,id);
    }
//    /**
//     * @Author Licc
//     * @Description  订单数量
//     * @Date 19:03 2020/11/3
//     * @Param
//     * @return
//     **/
//    @RequestMapping(value = "/orderSize",method = {RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
//    public JSONObject orderSize(String openid){
//        return orderService.orderSize(openid);
//    }
//    /**
//     * @Author Licc
//     * @Description  根据搜索条件查询订单
//     * @Date 19:40 2020/11/3
//     * @Param
//     * @return
//     **/
//    @RequestMapping(value = "/orderSize",method = {RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
//    public JSONObject orderSize(String openid){
//        return orderService.orderSize(openid);
//    }
}
