var explainerChoose = (function () {
    'use strict';
    var ExplainerChoose = function (params) {
        var p = this;
        p.params = {
            appid: '',
            id: '',
            accountsId: '',
            cfApp: null,
            devMode: false,
            localStorage: [],
            getexplainer: G.baseUri() + '/mobile/auth/appform/getexplainer',
            vt: ''
        };
        for (var param in params) {
            p.params[param] = params[param];
        }
        var cfApp = p.params.cfApp;

        if (p.params.devMode) {

        }
        p.pageSize = 10;
        p.pageNo = 0;
        p.channelData = [];
        /**
         * 判断app字段
         * @returns 是否app有值
         */
        var validAppField = function () {
            if (!p.params.appid || p.params.appid == '') {
                return false;
            } else {
                return true;
            }
        };

        /**
         * 确认初始化的app 和tokenId 两个值是否都存在
         * 如果不存在则获取一次,获取不到则初始化失败
         * @returns 初始化基础字段是否成功
         */
        var initBaseFields = function () {
            if (!validAppField()) {
                p.params.appid = cfApp.getQueryString('appid');
                p.params.id = cfApp.getQueryString('id');
                p.params.accountsId = cfApp.getQueryString('accountsId');
            }



            //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
            if (!validAppField()) {
                if (p.params.cfApp) {
                    p.params.appid = cfApp.getAppId();
                    //p.params.tokenId = cfApp.getTokenId();
                }
            }
            p.empInfo = cfApp.getMpInfo();
            p.params.accountsId = p.empInfo.accountsId;
            return validAppField();
        };

        /**
         * 初始化组件
         * @returns {boolean}
         */


        p.init = function () {


            if (initBaseFields()) {
                initDate();
                loadData();
                log();
                return true;
            } else {
                return false;
            }
        };

        var log = function () {
            var formdata = {
                openid: p.empInfo.openId,
                module: "展厅申请",
                modulename: '选择品牌大使列表',
                keyword: '选择品牌大使列表',
                keywordid: '',
                vt: new Date().getTime(),
                appid: cfApp.getQueryString('appid'),
                url: location.href
            };
            G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


            });
        }

        p.ischecked ="0";



        var initDate = function () {



            $(".tips i").click(function(){
                if($(this).hasClass("weui-icon-success")){
                    $(this).removeClass("weui-icon-success");
                    p.ischecked="0";
                }else{
                    $(this).addClass("weui-icon-success");
                    p.ischecked="1";
                    $(".explainer_container .explainer_item i").removeClass("weui-icon-success");
                }

            })
            $(".explainer_container").on("click",".explainer_item",function(e){
                e.stopPropagation();
                if($(this).find("i").hasClass("weui-icon-success")){
                    $(this).find("i").removeClass("weui-icon-success");
                    $(this).find("i").addClass("weui-icon-circle");
                    $(".tips i").addClass("weui-icon-success");
                }else{
                    $(this).siblings().find("i").removeClass("weui-icon-success");
                    $(this).siblings().find("i").addClass("weui-icon-circle");
                    $(this).find("i").addClass("weui-icon-success");
                    $(".tips i").removeClass("weui-icon-success");
                }
            })
            $(".explainer_container").on("click",".explainer_item .explainer_info a",function(e){
                e.stopPropagation();
            })

            $("#ok").click(function(){
                var url = "./explainer.html?appid="+p.params.appid;
                for(var i = 0;i<$(".explainer_container .explainer_item").length;i++){
                    var obj = $(".explainer_container .explainer_item:eq("+i+")");
                    if(obj.find("i").hasClass("weui-icon-success")){
                        var name = obj.attr("data-name");
                        var id = obj.attr("data-id");
                        location.href=url+"&explainer="+id+"&explainerName="+name;
                        return false;
                    }
                }
                var explainerStatus = 1;
                if($(".tips i").hasClass("weui-icon-success")){//需要但，时间冲突
                    explainerStatus = 2;
                }
                location.href=url+"&explainerStatus="+explainerStatus;
            })
        }
        var loadData = function () {
            var formdata = {};
            G.ajax('get', p.params.getexplainer, formdata, function (retdata) {
                if(retdata.errorNo=='0'){
                    for(var i = 0;i<retdata.datas.length;i++) {
                        retdata.datas[i].isSelected = false;
                        if (retdata.datas[i].id == cfApp.getQueryString("id")) {
                            retdata.datas[i].isSelected = true;
                            $(".tips i").removeClass("weui-icon-success");
                        }
                    }
                    var content = $('#detail-template').html();
                    p.template = Handlebars.compile(content);
                    var htmlStr = p.template(retdata);
                    $('.explainer_container').html(htmlStr);
                }
            })
        }


    };

    return ExplainerChoose;
})();
