/**
 * 常用的字符串验证
 * @author Neil
 * @date 2016-06-02
 * @description 
 *  StringValidateUtils.validChinese(需要校验的文本) 是否是汉字,返回true/false
 *  StringValidateUtils.validPassword(需要校验的文本) 是否是数字、26个英文字母或下划线组成,返回true/false
 *  StringValidateUtils.validEmail(需要校验的文本) 是否是Email格式,返回true/false
 *  StringValidateUtils.validIdCard(需要校验的文本) 是否是身份证格式(包含15位和18位),返回true/false
 *  StringValidateUtils.validStrlength(需要校验的文本,指定的长度(数字)) 是否指定长度内可空,返回true/false
 *  StringValidateUtils.validStrRange(需要校验的文本,指定的最小长度(数字),指定的最大长度(数字)) 是否指定长度范围内可空,返回true/false
 *  StringValidateUtils.validMobile(需要校验的文本) 是否是手机格式,返回true/false
 *  StringValidateUtils.validAmount(需要校验的文本) 是否是金额且二位小数内,返回true/false
 *  StringValidateUtils.validDateFormat(需要校验的文本) 是否是日期格式(YYYY-MM-DD),返回true/false
 *  StringValidateUtils.isEmpty(需要校验的文本) 是否为空,空字符串也返回true,返回true/false
 */
var StringValidateUtils = (function() {
  'use strict';
  //只能是中文
  var chineseValidRegex = /^[\u4e00-\u9fa5]{0,}$/;
  //只能是数字、26个英文字母或下划线组成，一般使用在密码上
  var pwdValidRegex = /^\w+$/;
  //E-mail
  var emailValidRegex = /^([a-zA-Z0-9]+[_|\_|\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\_|\.]?)*[a-zA-Z0-9]+\.[a-zA-Z]{2,3}$/;
  //校验身份证号码
  var idCardValidRegex = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
  //手机号码
//  var mobileValidRegex = /^((\+?86)|(\(\+86\)))?(13[0123456789][0-9]{8}|17[012356789][0-9]{8}|15[012356789][0-9]{8}|18[02356789][0-9]{8}|147[0-9]{8}|1349[0-9]{7})$/;
  var mobileValidRegex = /^1[1-9]\d{9}$/;
  //var mobileValidRegex = /^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(18[0,5-9]))\d{8}$/;
  //金额,保留2位小数,可为整数,一位小数和两位小数
  var amountValidRegex = /^[0-9]+(.[0-9]{1,2})?$/;
  //日期格式校验"YYYY-MM-DD"
  var dateValidRegex = /^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$/;

  return {
    validChinese: function(arg) {
      return chineseValidRegex.test(arg);
    },
    isEmpty: function(arg) {
    	arg=arg+"";
      if (arg.replace(/(^s*)|(s*$)/g, "").length ==0) {
        return true;
      } else
        return false;
    },
    validPassword: function(arg) {
      return pwdValidRegex.test(arg);
    },
    validEmail: function(arg) {
      return emailValidRegex.test(arg);
    },
    validIdCard: function(arg) {
      return idCardValidRegex.test(arg);
    },
    validStrlength: function(arg, orderLength) {
      var strLengthValid = new RegExp("^\\s*\\S((.){0,"+orderLength+"}\\S)?\\s*$");
      return strLengthValid.test(arg);
    },
    validStrRange: function(arg, minLength, maxLength) {
      var strLengthValid = new RegExp("^\\s*\\S((.){"+minLength+","+maxLength+"}\\S)?\\s*$");
      return strLengthValid.test(arg);
    },
    validMobile: function(arg) {
      return mobileValidRegex.test(arg);
    },
    validAmount: function(arg) {
      return amountValidRegex.test(arg);
    },
    validDateFormat: function(arg) {
      return dateValidRegex.test(arg);
    }

  }

})();
/**
 * 常用的字符串验证
 * @author Neil
 * @date 2016-06-02
 * @description 
 *  StringValidateUtils.validChinese(需要校验的文本) 是否是汉字,返回true/false
 *  StringValidateUtils.validPassword(需要校验的文本) 是否是数字、26个英文字母或下划线组成,返回true/false
 *  StringValidateUtils.validEmail(需要校验的文本) 是否是Email格式,返回true/false
 *  StringValidateUtils.validIdCard(需要校验的文本) 是否是身份证格式(包含15位和18位),返回true/false
 *  StringValidateUtils.validStrlength(需要校验的文本,指定的长度(数字)) 是否指定长度内可空,返回true/false
 *  StringValidateUtils.validStrRange(需要校验的文本,指定的最小长度(数字),指定的最大长度(数字)) 是否指定长度范围内可空,返回true/false
 *  StringValidateUtils.validMobile(需要校验的文本) 是否是手机格式,返回true/false
 *  StringValidateUtils.validAmount(需要校验的文本) 是否是金额且二位小数内,返回true/false
 *  StringValidateUtils.validDateFormat(需要校验的文本) 是否是日期格式(YYYY-MM-DD),返回true/false
 *  StringValidateUtils.isEmpty(需要校验的文本) 是否为空,空字符串也返回true,返回true/false
 */
var StringValidateUtils = (function() {
  'use strict';
  //只能是中文
  var chineseValidRegex = /^[\u4e00-\u9fa5]{0,}$/;
  //只能是数字、26个英文字母或下划线组成，一般使用在密码上
  var pwdValidRegex = /^\w+$/;
  //E-mail
  var emailValidRegex = /^([a-zA-Z0-9]+[_|\_|\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\_|\.]?)*[a-zA-Z0-9]+\.[a-zA-Z]{2,3}$/;
  //校验身份证号码
  var idCardValidRegex = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
  //手机号码
  //var mobileValidRegex = /^((\+?86)|(\(\+86\)))?(13[012356789][0-9]{8}|17[012356789][0-9]{8}|15[012356789][0-9]{8}|18[02356789][0-9]{8}|147[0-9]{8}|1349[0-9]{7})$/;
    var mobileValidRegex = /^1[1-9]\d{9}$/;
  //金额,保留2位小数,可为整数,一位小数和两位小数
  var amountValidRegex = /^[0-9]+(.[0-9]{1,2})?$/;
  //日期格式校验"YYYY-MM-DD"
  var dateValidRegex = /^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$/;

  return {
    validChinese: function(arg) {
      return chineseValidRegex.test(arg);
    },
    isEmpty: function(arg) {
    	arg=arg+"";
      if (arg.replace(/(^s*)|(s*$)/g, "").length ==0) {
        return true;
      } else
        return false;
    },
    validPassword: function(arg) {
      return pwdValidRegex.test(arg);
    },
    validEmail: function(arg) {
      return emailValidRegex.test(arg);
    },
    validIdCard: function(arg) {
      return idCardValidRegex.test(arg);
    },
    validStrlength: function(arg, orderLength) {
      var strLengthValid = new RegExp("^\\s*\\S((.){0,"+orderLength+"}\\S)?\\s*$");
      return strLengthValid.test(arg);
    },
    validStrRange: function(arg, minLength, maxLength) {
      var strLengthValid = new RegExp("^\\s*\\S((.){"+minLength+","+maxLength+"}\\S)?\\s*$");
      return strLengthValid.test(arg);
    },
    validMobile: function(arg) {
      return mobileValidRegex.test(arg);
    },
    validAmount: function(arg) {
      return amountValidRegex.test(arg);
    },
    validDateFormat: function(arg) {
      return dateValidRegex.test(arg);
    }

  }

})();
