/**
 * File Name：CityController.java
 * <p>
 * Copyright Defonds Corporation 2015
 * All Rights Reserved
 */
package com.cftech.sys.controller;

import com.cftech.sys.service.CityService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 *
 * Project Name：bdp
 * Type Name：CityController
 * Type Description：
 * Author：Defonds
 * Create Date：2015-08-27
 * @version
 *
 */
@Controller
@RequestMapping("/assets/city")
public class CityController {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Autowired
    private CityService cityService;

    // C
    @RequestMapping(value = "/create"
            , method = {RequestMethod.POST}
    )
    @ResponseBody
    public Integer create(@RequestParam(value = "city_code", defaultValue = "") String city_code,
                          @RequestParam(value = "city_jb", defaultValue = "") String city_jb,
                          @RequestParam(value = "province_code", defaultValue = "") String province_code,
                          @RequestParam(value = "city_name", defaultValue = "") String city_name,
                          @RequestParam(value = "city", defaultValue = "") String city,
                          @RequestParam(value = "province", defaultValue = "") String province) {
        logger.info(city_name);
        this.cityService.insertCity(city_code, city_jb, province_code, city_name, city, province);
        return 1;
    }

    // R
    @RequestMapping(value = "/province/cities"
            , method = {RequestMethod.POST}
    )
    @ResponseBody
    public Object provinceCities(@RequestParam(value = "province", defaultValue = "") String province) {
        logger.info("province=" + province);
        return this.cityService.provinceCities(province);
    }

    // R
    @RequestMapping(value = "/search"
            , method = {RequestMethod.GET, RequestMethod.GET}
    )
    @ResponseBody
    public Object searchCity(@RequestParam(value = "city_code", defaultValue = "") String city_code) {
        logger.info("city_code=" + city_code);
        return this.cityService.searchCity(city_code);
    }

    // U
    @RequestMapping(value = "/rename"
            , method = {RequestMethod.POST}
    )
    @ResponseBody
    public Object renameCity(@RequestParam(value = "city_code", defaultValue = "") String city_code,
                             @RequestParam(value = "city_name", defaultValue = "") String city_name) {
        logger.info(city_name);
        return this.cityService.renameCity(city_code, city_name);
    }

    // D
    @RequestMapping(value = "/destroy",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public Object deleteCity(@RequestParam(value = "city_code", defaultValue = "") String city_code) {
        return this.cityService.deleteCity(city_code);
    }

}