package com.cftech.common.supplier.service.impl;

import com.cftech.common.manager.model.Manager;
import com.cftech.common.manager.model.ManagerDto;
import com.cftech.common.supplier.dao.SupplierMapper;
import com.cftech.common.supplier.model.Supplier;
import com.cftech.common.supplier.model.SupplierDto;
import com.cftech.common.supplier.service.SupplierService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lisw
 * @program schaeffler
 * @description
 * @createDate 2020-01-15 16:33:19
 **/
@Service
public class SupplierServiceImpl extends GenericServiceImpl<Supplier> implements SupplierService {

    @Autowired
    private SupplierMapper supplierMapper;

    @Override
    protected GenericDao<Supplier> getGenericMapper() {
        return supplierMapper;
    }

    @Override
    public boolean emptyTable(String[] ids,Long createBy,Long accountsId,Long typeform) {
        supplierMapper.emptyTable(typeform);
        if(ids!=null && ids.length>0){
            for(String str : ids){
                Supplier supplier = new Supplier();
                supplier.setOpenid(str);
                supplier.setCreateBy(createBy);
                supplier.setUpdateBy(createBy);
                supplier.setAccountsId(accountsId);
                supplier.setTypeform(typeform);
                supplierMapper.save(supplier);
            }
        }
        return true;
    }

    @Override
    public List<SupplierDto> fetchOpenidNickName(Long typeform) {
        Map<String,Object> parmas = new HashMap<>();
        parmas.put("typeform",typeform);
        return supplierMapper.fetchOpenidNickName(typeform);
    }
}
