package com.cftech.common.promotionstock.service;

import com.cftech.common.promotionstock.model.*;
import com.cftech.common.typeappform.model.TypeAppForm;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author lisw
 * @program schaeffler
 * @description 促销品库存接口定义
 * @createDate 2020-01-12 19:08:23
 **/
public interface PromotionStockService extends GenericService<PromotionStock> {

    List<PStockStatisticalDto> fetchPStockStatistical(String startDate,String endDate);


    List<GrantDetailDto> managerGrantDetail(String startDate,String endDate);

    List<AfterStockDto> managerAfterStock(String startDate,String endDate);

    List<GrantDetailDto> supplierGrantDetail(String startDate,String endDate);

    BigDecimal supplierLogisticsPrice(String startDate, String endDate);

    List<GrantDetailDto> deptGrantDetails(String startDate,String endDate);

    List<GrantDetailDto> useGrantDetails(String startDate,String endDate);

    EvalityNumberDto managerEvaluate(String startDate,String endDate);

    EvalityNumberDto applyEvaluate(String startDate,String endDate);

    Integer managerConfirm(String startDate,String endDate);

    List<TypeAppForm> fetchSearchByPageByAppform(Conds conds, String startDate, String endDate);

    List<SupplierStockDto> getSupplierStockStatistics(Map<String,Object> params);
}
