package com.cftech.base.org.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * OrgUnit 实体类
 * Created by mb 07/11/2016.
 */ 
@Data
public class OrgUnit implements Serializable {
	/**
	 * id
	 */
	private Long id;

	/**
	 * 组织编码
	 */
	@ExportConfig(value = "组织编码", width = 120)
	private String number;
	/**
	 * 组织名称
	 */
	@ExportConfig(value = "组织名称", width = 120)
	private String orgName;
	/**
	 * 微信组织id
	 */
	//@ExportConfig(value = "微信组织id", width = 100, showLevel = 1)
	private String wxorgId;

	/* 父级组织 */
	//@ExportConfig(value = "上级组织编码", width = 100, showLevel = 2)
	private Long parentId;

	@ExportConfig(value = "上级组织编码", width = 120)
	private String parentCode;

	@ExportConfig(value = "上级组织名称", width = 120)
	private String parentName;

	/**
	 * 组织分类
	 */
	//@ExportConfig(value = "组织分类", width = 100)
	private Long orgtypeId;

	/**
	 *关联的服务号或企业号的id
	 */
	private Long accountsId;

	/* 所有的父级Id, 用逗号分割，例如 0,1,2 */
	private String parentIds;

	/* 是否是行政组织 */
	private Boolean isAdminUnit; 
	/* 是否是销售组织 */
	private Boolean isSalesUnit;
	/**
	 * 创建人
	 */
	private Long createBy;
	/**
	 * 创建时间
	 */
	@JSONField(format="yyyy-MM-dd HH:mm:ss")
	private Timestamp createTime;
	/**
	 * 修改人
	 */
	private Long updateBy;
	/**
	 * 修改时间
	 */
	@JSONField(format="yyyy-MM-dd HH:mm:ss") 
	private Timestamp updateTime;
	/**
	 * 是否删除
	 */
	private boolean delFlag;

	/* 状态 是否禁用,默认启用，0 启用，1禁用*/
	private String status;

	public OrgUnit() {
		this.delFlag = false;
		this.status = "0";
		this.isAdminUnit = false;
		this.isSalesUnit = true;
	}

}