package com.cftech.product.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 产品
 *
 * @author Buyj
 * @date: 2020-09-24 15:07
 */
@Data
public class Product implements Serializable {

    /**
     * 主键id
     */
    private Long id;
    /**
     * 产品分类ID
     */
    private String classifyId;
    /**
     * 产品分类编码
     */
    @ExportConfig(value = "产品分类编码（多个分类用英文逗号隔开,必填字段）", width = 250, showLevel = 2)
    private String classifyNumber;
    /**
     * 产品分类名称
     */
    @ExportConfig(value = "产品分类名称（必填字段）", width = 150, showLevel = 1)
    private String classifyName;

    /**
     * 产品编码
     */
    @ExportConfig(value = "产品编码（必填字段）", width = 100)
    private String productNumber;
    /**
     * 产品名称
     */
    @ExportConfig(value = "产品名称", width = 100)
    private String productName;
    /**
     * 通用名
     */
    @ExportConfig(value = "通用名", width = 100)
    private String commonName;
    /**
     * 剂型
     */
    @ExportConfig(value = "剂型", width = 100)
    private String dosagaFrom;
    /**
     * 规格
     */
    @ExportConfig(value = "规格", width = 100)
    private String format;
    /**
     * 批准文号
     */
    @ExportConfig(value = "批准文号", width = 100)
    private String approveNumber;
    /**
     * 生产企业
     */
    @ExportConfig(value = "生产企业", width = 100)
    private String manufacturer;
    /**
     * 推荐计量
     */
    @ExportConfig(value = "推荐计量", width = 100)
    private String recommendMeasure;

    /**
     * 药品简介
     */
    @ExportConfig(value = "药品简介", width = 150)
    private String description;
    /**
     * 温馨提示
     */
    @ExportConfig(value = "温馨提示", width = 100)
    private String tips;
    /**
     * 服用类型
     */
    @ExportConfig(value = "服用类型(天/周/月)", width = 200)
    private String takeType;
    /**
     * 服用频率
     */
    @ExportConfig(value = "服用频率", width = 100)
    private String takeFrequency;
    /**
     * 服用次数
     */
    @ExportConfig(value = "服用数量", width = 100)
    private String takeAmount;
    /**
     * 库存
     */
    @ExportConfig(value = "库存（必填字段）", width = 100)
    private Long stock;
    /**
     * 价格
     */
    @ExportConfig(value = "价格", width = 100)
    private Double price;

    /**
     * 是否为处方药
     */
    @ExportConfig(value = "是否为处方药（是/否）", width = 200)
    private String isRs;

    /**
     * 产品详情图
     */
    private String productImgDetail;
    /**
     * 产品图片
     */
    private String productImg;
    /**
     * 入库编码
     */
    private String ruKuNumber;
    /**
     * 销量
     */
    @ExportConfig(value = "销量", width = 200)
    private String reading;
    /**
     * 单位
     */
    private String unit;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;

    private Long isreading;

    private Long size;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Product() {
        this.delFlag = false;
        this.status = "0";
    }

}