package com.cftech.workshop.welcome.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.StringUtils;
import com.cftech.workshop.welcome.model.Welcome;
import com.cftech.workshop.welcome.service.WelcomeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

/**
 * Created by Ago on 2018/7/16.
 */
@RestController
@RequestMapping(value = "/mobile/auth/welcome")
public class MobileWelcomeController {


    @Autowired
    private WelcomeService welcomeService;

    /**
     * 获得欢迎信内容图
     * @param meetingId   研讨会id
     * @return
     */

    @RequestMapping(value = "/getwelcome",method = {RequestMethod.GET,RequestMethod.POST},produces={"application/json;charset=UTF-8"})
    public JSONObject getwelcome(Long meetingId){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(meetingId))){
                Conds conds = new Conds();
                conds.equal("del_flag",0);
                conds.equal("meetingId",meetingId);
               Welcome welcome = welcomeService.fetchSearchByConds(conds);
                if(welcome!=null){
                    jsonObject.put("data",welcome);
                    jsonObject.put("errorNo",0);
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }
}
