package com.cftech.base.org.service.impl;

import com.cftech.base.org.dao.QytagMapper;
import com.cftech.base.org.model.Qytag;
import com.cftech.base.org.service.QytagService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * qytagService
 * Created by Neil 14/02/2017.
 */
@Service("qytagService")
public class QytagServiceImpl extends GenericServiceImpl<Qytag> implements QytagService {

    /**
     * qytagMapper
     */
    @Autowired
    @Qualifier("qytagMapper")
    private QytagMapper qytagMapper;

    @Override
    public GenericDao<Qytag> getGenericMapper() {
        return qytagMapper;
    }

    @Override
    public void changeStatus(String status, Conds conds) {
        Map<String, Object> params = new HashMap<>();
        params.put("conds", conds);
        params.put("status", status);
        qytagMapper.changeStatus(params);
    }
}
