package org.mp.api.coupon.location;

import com.cftech.core.util.DateUtils;
import net.sf.json.JSONObject;
import org.mp.api.core.exception.WexinReqException;
import org.mp.api.core.req.WeiXinReqService;
import org.mp.api.coupon.location.model.*;
import org.mp.api.coupon.manage.model.Card;
import org.mp.api.coupon.manage.model.DateInfo;
import org.mp.api.coupon.manage.model.Sku;

import java.util.Date;


/**
 * 微信卡券 - 创建卡券
 * @author lihongxuan
 *
 */
public class JwLocationAPI {
	/*// 上传LOGO 大小限制1MB，像素为300*300，支持JPG格式。
	private static String uploadimg_location_url = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=ACCESS_TOKEN";
	*/// 批量导入门店信息
	private static String batchadd_location_url = "https://api.weixin.qq.com/card/location/batchadd?access_token=ACCESS_TOKEN";
	// 拉取门店列表
	private static String batchget_location_url = "https://api.weixin.qq.com/card/location/batchget?access_token=ACCESS_TOKEN";
	// 获取颜色列表
	private static String getcolors_location_url = "https://api.weixin.qq.com/card/getcolors?access_token=ACCESS_TOKEN";
	// CreateCard 创建卡
	private static String add_card_url = "https://api.weixin.qq.com/card/create?access_token=ACCESS_TOKEN";
	
	/**
	 * 批量导入门店信息
	 * @throws WexinReqException 
	 */
	public BatchaddRtn doBatchadd(String accesstoken,Batchadd batchadd) throws WexinReqException {
		if (accesstoken != null) {
			batchadd.setAccess_token(accesstoken);
			JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(batchadd);
			BatchaddRtn batchaddRtn = (BatchaddRtn)JSONObject.toBean(result, BatchaddRtn.class);
			return batchaddRtn;
		}
		return null;
	}
	
	/**
	 * 拉取门店列表
	 */
	public BatchgetRtn doBatchget(String accesstoken,Batchget batchget) throws WexinReqException{
		if (accesstoken != null) {
			batchget.setAccess_token(accesstoken);
			JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(batchget);
			BatchgetRtn batchgetRtn = (BatchgetRtn)JSONObject.toBean(result, BatchgetRtn.class);
			return batchgetRtn;
		}
		return null;
	}
	
	/**
	 * 获取颜色列表
	 */
	public static GetcolorsRtn doGetcolors(String accesstoken) throws WexinReqException {
		if (accesstoken != null) {
			Getcolors gk = new Getcolors();
			gk.setAccess_token(accesstoken);
			JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(gk);
			GetcolorsRtn getcolorsRtn = (GetcolorsRtn)JSONObject.toBean(result, GetcolorsRtn.class);
			return getcolorsRtn;
		}
		return null;
	}
	
	/**
	 *  CreateCard 创建卡
	 */
	public static CardInfoRtn doAddCard(String accesstoken,CardInfo cardInfo) throws WexinReqException{
		if (accesstoken != null) {
			cardInfo.setAccess_token(accesstoken);
			JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(cardInfo);
			CardInfoRtn cardInfoRtn = (CardInfoRtn)JSONObject.toBean(result, CardInfoRtn.class);
			return cardInfoRtn;
		}
		return null;
	}
	
	/**
	 *  CreateCard 创建微信卡券
	 */
	public static CardInfoRtn doAddCardWechat(String accesstoken,CardInfo cardInfo) throws WexinReqException{
		if (accesstoken != null) {
			cardInfo.setAccess_token(accesstoken);
			JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(cardInfo);
			CardInfoRtn cardInfoRtn = (CardInfoRtn)JSONObject.toBean(result, CardInfoRtn.class);
			return cardInfoRtn;
		}
		return null;
	}
	
	
	public static void main(String[] args) throws WexinReqException {
		System.out.println(new Date().getTime()/1000);
		System.out.println(DateUtils.parseDate("2016-11-20 13:55:00").getTime()/1000);
		
		
		String token = "6xN43Xzr99ylGO5KJA2pI8iWYJUhSQOTe8Jpz8tgbNOc_fSw5YOpxt59G8KScCIIYEFoetQpDW5VsVyWfb0uUinRUc7F4jnjJJDc2U057JYFGQiAIATUE";
		CardInfo cardInfos = new CardInfo();
		Card cardInfo = new Card();
		cardInfo.setCard_type("GROUPON");
		org.mp.api.coupon.manage.model.Groupon groupon = new org.mp.api.coupon.manage.model.Groupon();
		groupon.setDeal_detail("xiangqingasdfasdfsafasdf");
		org.mp.api.coupon.manage.model.BaseInfo baseInfo = new org.mp.api.coupon.manage.model.BaseInfo();
		baseInfo.setBind_openid(false);
		baseInfo.setBrand_name("商户名字");
		baseInfo.setCan_give_friend(true);
		baseInfo.setCan_share(false);
		baseInfo.setCode_type("CODE_TYPE_TEXT");
		baseInfo.setColor("Color010");
		baseInfo.setGet_limit(1); 
		baseInfo.setDescription("111111111111");
		baseInfo.setNotice("22222222222");
		baseInfo.setLogo_url("http://mmbiz.qpic.cn/mmbiz_jpg/0mx7AkWWoEpfBToWPVABictHNqBPkBrMTX6Z92yYF9sc642jjClImfd3c2qBMfVF88mx0KfOcvcALlj5kR0ycDg/0");
		baseInfo.setTitle("1231231231212312111");
		Sku sku = new Sku();
		sku.setQuantity(100);
		baseInfo.setSku(sku);
		DateInfo dateInfo = new DateInfo();
		dateInfo.setType("DATE_TYPE_FIX_TIME_RANGE");
		dateInfo.setBegin_timestamp(1479275656L);
		dateInfo.setEnd_timestamp(1479621300L);
		baseInfo.setDate_info(dateInfo);
		groupon.setBase_info(baseInfo);
		cardInfo.setGroupon(groupon);
		cardInfos.setCard(cardInfo);
		CardInfoRtn t = JwLocationAPI.doAddCard(token, cardInfos);
		System.out.println("11");
		JwLocationAPI jwLocationApi = new JwLocationAPI();
		GetcolorsRtn color =  jwLocationApi.doGetcolors("nM5fjXQVUDKglqjH2Geq7IIB6XakiTOJ6ecKRaWDBQ7x8kwylWhjDmuhqioQ9txpuOIpvMaFfdotYcJSJzWbOXYg0XB7KbZfh9g4fIUNjw8ni3RKxB9mrsz8mmjElw_YECXiACAMKF");
		if(color!=null && color.getColors().size()>0){
			for(Color c : color.getColors()){
				System.out.println(c.getName()+":"+c.getValue());
			}
		}
	}

}
 