package com.cftech.report.service;

import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.report.model.Report;
import com.cftech.core.generic.GenericService;
import com.cftech.report.model.ReportCode;
import com.cftech.report.model.ReportDoctorInfo;
import com.cftech.report.model.ReportPeopleInfo;

import java.util.List;
import java.util.Map;

/**
 * 报表信息Service
 *
 * @author Buyj
 * @date: 2020-12-02 11:26
 */
public interface ReportService extends GenericService<Report> {

    /**
     * 查询报表人员信息
     * @param cond
     * @param sort
     * @return
     */
    List<ReportPeopleInfo> selectReportPeopleInfo(Conds cond, Sort sort);

    /**
     *  查询用户对应的扫码记录信息
     * @param cond
     * @param sort
     * @return
     */
    List<ReportCode> selectReportCodeInfo(Conds cond, Sort sort);

    /**
     * 根据医生ID查询医生信息
     * @param cond
     * @return
     */
    ReportDoctorInfo selectReportDoctorInfo(Conds cond);
}
