var editInform = (function () {
  'use strict';
  var EditInform = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      dataApi: G.baseUri() + '/mobile/auth/member/getemembercenterdetails',
      editApi: G.baseUri() + '/mobile/auth/member/updatemembercenter',
      vt: ''
    };

    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;

    if (p.params.devMode) {
      p.params.dataApi = 'json/edit-information.json';
      p.params.editApi = 'json/code.json';

    }
    p.english = cfApp.getQueryString('english') == 1 ? true : false;
    console.log(p.english);

    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {



      if (initBaseFields()) {

        log();
        loadData();
        submit();
        $('.language').click(function () {
          if(!p.english){
location.href = 'edit-information-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1'+"&redirectURL="+encodeURIComponent(cfApp.getQueryString("redirectURL"));
          }else{
location.href = 'edit-information.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id')+"&redirectURL="+encodeURIComponent(cfApp.getQueryString("redirectURL"));;
          }
          
        });
        return true;
      } else {
        return false;
      }
    };
    var log = function () {
      var formdata = {
        openid: p.empInfo.openId,
        module: "个人中心",
        modulename: "编辑信息",
        keyword: "编辑信息",
        keywordid: '',
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


      });
    }

    var loadData = function () {
      $.showLoading();
      var formdata = {
        member_uid: p.empInfo.memberId
        //openid: p.empInfo.openId
      };
      G.ajax('get', p.params.dataApi, formdata, function (retdata) {
        $.hideLoading();
        var data = retdata.data;
        if (retdata.errorNo == '0') {
          console.log(data);
          $('#avatar').attr('src', data.imageurl);
          $('#lastName').val(data.surname);
          $('#firstName').val(data.name);
          $('#phone').val(data.phone);
          $('#company').val(data.compan);
          $('#position').val(data.position);
        }

      });


    }

    var submit = function () {
      $('#submit').click(function () {
        var lastName = $('#lastName').val();
        if (StringValidateUtils.isEmpty(lastName)) {
          $.modal({
            title: "",
            text: '<span class="color-green">请输入您的姓氏！</span><br>Please input the<br>last name',
            buttons: [{
              text: "确定OK"
            }]
          });
          return false;

        }
        var firstName = $('#firstName').val();
        if (StringValidateUtils.isEmpty(firstName)) {
          $.modal({
            title: "",
            text: '<span class="color-green">请输入您的名字！</span><br>Please input the<br>first name',
            buttons: [{
              text: "确定OK"
            }]
          });
          return false;
        }


        var phone = $('#phone').val();
        // if (StringValidateUtils.isEmpty(phone)) {
        //   $.modal({
        //     title: "",
        //     text: '<span class="color-green">请输入手机号！</span><br>Please input the<br>phone number',
        //     buttons: [{
        //       text: "确定OK"
        //     }]
        //   });
        //   return false;
        // }
        // if (!StringValidateUtils.validMobile(phone)) {
        //   $.modal({
        //     title: "",
        //     text: '<span class="color-green">请输入正确的手机号！</span><br>Please input the<br>correct phone number',
        //     buttons: [{
        //       text: "确定OK"
        //     }]
        //   });
        //   return false;
        // }
        var company = $('#company').val();
        // if (StringValidateUtils.isEmpty(company)) {
        //   $.modal({
        //     title: "",
        //     text: '<span class="color-green">请输入您的公司！</span><br>Please input the<br>company',
        //     buttons: [{
        //       text: "确定OK"
        //     }]
        //   });
        //   return false;
        // }
        var position = $('#position').val();
        // if (StringValidateUtils.isEmpty(position)) {
        //   $.modal({
        //     title: "",
        //     text: '<span class="color-green">请输入您的职位！</span><br>Please input the<br>position',
        //     buttons: [{
        //       text: "确定OK"
        //     }]
        //   });
        //   return false;
        // }



        var formdata = {

          phone: phone,
          name: firstName,
          surname: lastName,
          imageurl: $('#avatar').attr('src'),
          member_uid:p.empInfo.memberId,
          compan: company,
          position: position
        }

        G.ajax(G.devModePost, p.params.editApi, formdata, function (retdata) {
          //0:获取成功 1:获取异常 2:参数错误 3:验证码不正确 4:手机号被占用 5:此openId已注册
          if (retdata.errorNo == '0') {
            //注册成功
            $.modal({
              title: "",
              text: '<span class="color-green">修改成功！</span></br>Success',
              buttons: [{
                text: "确定OK", onClick: function () {
                  // if (p.english) {
                  //   location.href = 'personCenter-english.html?appid=' + p.params.appid + '&english=1';
                  // } else {
                  //   location.href = 'personCenter.html?appid=' + p.params.appid;
                  // }
                  location.href=decodeURIComponent(cfApp.getQueryString("redirectURL"));
                }

              }]
            });
          } else if (retdata.errorNo == '1') {
            $.modal({
              title: "",
              text: '<span class="color-green">获取异常！</span></br>System error',
              buttons: [{
                text: "确定OK"
              }]
            });
          }

        })
      });
    }


  };

  return EditInform;
})();