package com.cftech.workshop.agenda_customiz.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.sys.dao.UserMapper;
import com.cftech.sys.model.User;
import com.cftech.workshop.agenda_customiz.model.Agenda_customiz;
import com.cftech.workshop.agenda_customiz.dao.Agenda_customizMapper;
import com.cftech.workshop.agenda_customiz.model.Agenda_customizDto;
import com.cftech.workshop.agenda_customiz.service.Agenda_customizService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2018-08-02 11:30
 */
@Service("agenda_customizService")
public class Agenda_customizServiceImpl extends GenericServiceImpl<Agenda_customiz> implements Agenda_customizService {

    @Autowired
    @Qualifier("agenda_customizMapper")
    private Agenda_customizMapper agenda_customizMapper;
    @Autowired
    private UserMapper userMapper;

    @Override
    public GenericDao<Agenda_customiz> getGenericMapper() {
        return agenda_customizMapper;
    }

    @Override
    public List<Agenda_customizDto> selectcustomizname(Conds conds, Sort sort, int page, int pagesize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pagesize > 0 ? pagesize : 0);
        params.put("sort", sort);
        return agenda_customizMapper.selectcustomizname(params);
    };

    /**
     * 用户绑定会场
     * @param agenda_customiz
     * @return
     */
    @Override
    public boolean updateuser(Agenda_customiz agenda_customiz,Long userid){
            boolean flag = false;
        try {
            int  i = agenda_customizMapper.update(agenda_customiz);
            if(userid != 0){
                //判断改会场是否绑定过用户
                Map map = new HashMap();
                Conds conds = new Conds();
                conds.equal("delflag",0);
                conds.equal("customiz_id",agenda_customiz.getId());
                map.put("conds",conds);
                List<User> list = userMapper.fetchSearchByPage(map);
                if(list.size()>0){
                    for (User user : list){
                        user.setCustomiz_id(Long.valueOf(0));
                        userMapper.update(user);
                    }
                }
                User user1 = userMapper.fetchById(userid);
                user1.setCustomiz_id(agenda_customiz.getId());
                userMapper.update(user1);

            }else{
                Map map = new HashMap();
                Conds conds = new Conds();
                conds.equal("delflag",0);
                conds.equal("customiz_id",agenda_customiz.getId());
                map.put("conds",conds);
                List<User> list = userMapper.fetchSearchByPage(map);
                if(list.size()>0){
                    for (User user : list){
                        user.setCustomiz_id(Long.valueOf(0));
                        userMapper.update(user);
                    }
                }
            }
                if(i>0){
                    flag = true;
                }

        }catch (Exception e){
            e.printStackTrace();
        }
        return  flag;
    };


    /**
     * 添加会场   用户表绑定会场
     * @param agenda_customiz
     * @return
     */
    @Override
    public boolean addusercustomiz(Agenda_customiz agenda_customiz,Long userid){
        boolean flag = false;
        try {
            Long i = agenda_customizMapper.save(agenda_customiz);
            User user = userMapper.fetchById(userid);
           if(userid != 0){
               user.setCustomiz_id(agenda_customiz.getId());
               userMapper.update(user);
           }
            if(i>0){
                flag = true;
            }

        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    };

}