package com.cftech.base.appmenu.service.impl;

import com.cftech.base.appmenu.dao.AppmenuMapper;
import com.cftech.base.appmenu.model.Appmenu;
import com.cftech.base.appmenu.service.AppmenuService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * appmenuService
 * Created by Neil 28/02/2017.
 */
@Service("appmenuService")
public class AppmenuServiceImpl extends GenericServiceImpl<Appmenu> implements AppmenuService {

    /**
     * appmenuMapper
     */
    @Autowired
    @Qualifier("appmenuMapper")
    private AppmenuMapper appmenuMapper;

    @Override
    public GenericDao<Appmenu> getGenericMapper() {
        return appmenuMapper;
    }

    @Override
    public List<Appmenu> findByAccountsIdAndPositionIdAndApp(Long accountsId, Long positionId, Long app) {
        Map<String, Object> params = new HashMap<>();
        params.put("accountsId", accountsId);
        params.put("positionId", positionId);
        params.put("app", app);
        return appmenuMapper.findByAccountsIdAndPositionIdAndApp(params);
    }
}
