package com.cftech.activity.market.service;

import com.cftech.activity.market.model.Market;
import com.cftech.activity.market.model.MarketDto;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;

import java.util.List;

/**
* 市场活动Service
*
* @author faye
* @date: 2017-08-25 10:36
*/
public interface MarketService extends GenericService<Market> {

 List<MarketDto> fetchSearchByPageVo(Conds conds, Sort sort, int page, int pageSize, String brandid, Long storeid, String openid);

 int countVo(Conds conds);

 MarketDto fetchStoreidsAndBrandids(Conds conds);

 List<MarketDto> fetchActByBelong(Conds conds, Sort sort, int page, int pageSize,String openid,String brandid,Long storeid,boolean isAvail,Long memberId);

 int countActByBelong(Conds conds,String openid,String brandid,Long storeid,boolean isAvail);
 List<MarketDto> getActListByStore(Conds conds, Sort sort, int page, int pageSize, String openid);
}