package com.cftech.core.util;


/**
 * JSONResult : Response JSONResult for RESTful,封装返回JSON格式的数据
 *
 * @author lisw
 * @since 2016-09-09 09:29
 */

public class JSONResult<T> extends Result {

    private static final long serialVersionUID = 7880907731807860636L;

    /**
     *数据
     */
    private T data;


    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public JSONResult() {
        super();
    }

    /**
     * 自定义返回的结果
     *
     * @param data
     * @param message
     * @param success
     */
    public JSONResult(T data, String msg, int errorNo) {
        this.data = data;
        super.setMsg(msg);
        super.setErrorNo(errorNo);
    }

    /**
     * 只返回编码
     *
     * @param data
     * @param message
     */
    public JSONResult(int errorNo) {
        super.setErrorNo(errorNo);
    }
}