package com.cftech.module.activity.core.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.module.activity.core.dao.ActivityBaseResultMapper;
import com.cftech.module.activity.core.model.ActivityBaseResultDto;
import com.cftech.module.activity.core.model.ActivityBaseResultEntity;
import com.cftech.module.activity.core.service.ActivityBaseResultService;
import com.cftech.sys.model.User;
import com.cftech.sys.security.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuling on 2017/4/18.
 */
@Service
public class ActivityBaseResultServiceImpl extends GenericServiceImpl<ActivityBaseResultEntity> implements ActivityBaseResultService {

    @Autowired
    private ActivityBaseResultMapper resultMapper;

    @Override
    public GenericDao<ActivityBaseResultEntity> getGenericMapper() {
        return resultMapper;
    }

    @Override
    public void prizeLog(Long accountsId, String from, Long activityId, String title, String openId, String prize, int qty, String prizeDetail, String prizeType, String prizeAmount,Long desc) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("accountsId", accountsId);
        params.put("from", from);
        params.put("activityId", activityId);
        params.put("title", title);
        params.put("openId", openId);
        params.put("prize", prize);
        params.put("qty", qty);
        params.put("prizeDetail", prizeDetail);
        params.put("prizeType", prizeType);
        params.put("prizeAmount", prizeAmount);
        params.put("delFlag",0);
        params.put("description",desc);
        resultMapper.prizeLog(params);
    }

    @Override
    public List<ActivityBaseResultDto> fetchSearchByPageExport(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return resultMapper.fetchSearchByPageExport(params);
    }


    @Override
    public List<ActivityBaseResultEntity> fetchSearchByPage(Conds conds, Sort sort, int page, int pageSize ) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        if(!UserUtils.isAdmin()){
            params.put("userId", UserUtils.getUser().getId());
        }
       return resultMapper.fetchSearchByPage(params);
    }
    @Override
    public List<ActivityBaseResultEntity> selectmywin(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return resultMapper.selectmywin(params);
    };

    @Override
    public int count(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        if(!UserUtils.isAdmin()){
            params.put("userId", UserUtils.getUser().getId());
        }
        return getGenericMapper().count(params);
}
}
