package com.cftech.workshop.feedback.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.SendEmail.EmailSenderWithAttach;
import com.cftech.cms.SendEmail.MailBean;
import com.cftech.cms.exhibi.model.Exhibi;
import com.cftech.cms.exhibi_material.model.Exhibi_material;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.core.util.SystemConfig;
import com.cftech.workshop.feedback.model.Feedback;
import com.cftech.workshop.feedback.service.FeedbackService;
import org.owasp.esapi.ESAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * @Auther: lisw
 * @Date: 2019/6/18 15:42
 * @Description:
 */
@RestController
@RequestMapping(value = "/mobile/auth/feedback")
public class MobileFeedbackController {


    @Autowired
    private FeedbackService feedbackService;

    @RequestMapping(value = "getDetail",method = RequestMethod.GET)
    private JSONObject getDetail(String openId){
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("errorNo",0);
        Conds conds = new Conds();
        conds.equal("field1",openId);
        Sort sort = new Sort("create_time", OrderType.DESC);
        List<Feedback> feedbacks = feedbackService.fetchSearchByPage(conds,sort,0,1);
        if(feedbacks!=null && feedbacks.size()>0){
            rtnJson.put("data",feedbacks.get(0));
        }
        return rtnJson;
    }


    @RequestMapping(value = "/save", method = RequestMethod.POST)
    private JSONObject feedbackSave(Feedback feedback, String toEmail, String typeName, String subjectName) {
        JSONObject rtnJson = new JSONObject();
        try {
            rtnJson.put("errorNo", 0);
            if (StringUtils.isNotBlank(toEmail)) {
                String[] toEmails = toEmail.split(",");
                StringBuffer stringBuffer = new StringBuffer();
                for (String e : toEmails) {
                    MailBean mb = new MailBean();
                    mb.setHost(SystemConfig.p.getProperty("email.host"));
                    mb.setUsername(SystemConfig.p.getProperty("email.username"));
                    mb.setPassword(SystemConfig.p.getProperty("email.password"));
                    mb.setFrom(SystemConfig.p.getProperty("email.from"));
                    mb.setTo(e);
                    mb.setSubject(subjectName);
                    mb.setContent(rtnContent(feedback, typeName).toString());
                    String[] results = EmailSenderWithAttach.sendAttachEmail(mb.getHost(),
                            mb.getFrom(), mb.getTo(), mb.getSubject(), mb.getContent(), null, mb.getUsername(), mb.getPassword(), "465", mb.getFilename());
                    stringBuffer.append(e + ":" + results[0] + ":" + results[1]);
                }
                feedback.setDescription(stringBuffer.toString());
                feedback.setField2(toEmail);
                feedbackService.save(feedback);
            } else {
                rtnJson.put("errorNo", 2);
            }

        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
            e.printStackTrace();
        }
        return rtnJson;
    }


    private StringBuffer rtnContent(Feedback feedback, String typeName) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Dear,<br/>");
        stringBuffer.append("Following external inquiry has reached us via the Schaffler official WeChat : 舍弗勒Schaffler. <br/>");
        stringBuffer.append("Please handle/reply to this inquiry. Thanks!<br/><br/>");
        stringBuffer.append("<font style='font-weight:bold'>Inquiry Details</font><br/>");
        stringBuffer.append("姓名Name:" + (StringUtils.isNotBlank(feedback.getName()) ? feedback.getName() : "") + "<br/>");
        stringBuffer.append("电话Tel.:" + (StringUtils.isNotBlank(feedback.getPhone()) ? feedback.getPhone() : "") + "<br/>");
        stringBuffer.append("邮箱Email:" + (StringUtils.isNotBlank(feedback.getEmail()) ? feedback.getEmail() : "") + "<br/>");
        stringBuffer.append("公司Company:" + (StringUtils.isNotBlank(feedback.getCompany()) ? feedback.getCompany() : "") + "<br/>");
        stringBuffer.append("地址Address:" + (StringUtils.isNotBlank(feedback.getAddress()) ? feedback.getAddress() : "") + "<br/>");
        stringBuffer.append("咨询类型Inquiry category: " + (StringUtils.isNotBlank(typeName) ? typeName : "") + "<br/>");
        stringBuffer.append("咨询的问题Message to us:" + ESAPI.encoder().decodeForHTML(feedback.getContent()) + "<br/>");
        stringBuffer.append("<br/>");
        stringBuffer.append("Best regards,<br/>");
        stringBuffer.append("Communications and Branding Greater China<br/>");
        stringBuffer.append("<br/>");
        stringBuffer.append("No.1 Antuo Road, Anting, Jiading District, Shanghai, China (201804)<br/>");
        stringBuffer.append("General line : +86 21 3957 6666<br/>");
        stringBuffer.append("E-mail: info_china@aidea.com<br/>");
        stringBuffer.append("Website: www.schaeffler.cn<br/>");
        stringBuffer.append("<br/>");
        stringBuffer.append("This e-mail message is intended only for the use of the named recipient(s) and contains information which may be confidential or privileged. If you are not the intended recipient, be aware that any distribution, or use of the contents of this information is prohibited. If you have received this electronic transmission in error, please notify the sender and delete the material from the computer.");
        return stringBuffer;
    }


}


