package com.cftech.workshop.agenda_customiz.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.sys.model.User;
import com.cftech.sys.service.UserService;
import com.cftech.workshop.agenda_customiz.model.Agenda_customiz;
import com.cftech.workshop.agenda_customiz.service.Agenda_customizService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String AGENDA_CUSTOMIZ_VIEW = "qy:agenda_customiz:view"
 * 查看:public static final String AGENDA_CUSTOMIZ_EDIT = "qy:agenda_customiz:edit"
 *
 * @author byj
 * @date: 2018-08-02 11:30
 */
@Slf4j
@Controller
@RequestMapping("/a/agenda_customiz")
public class Agenda_customizController {

    public static final String AGENDA_CUSTOMIZ_VIEW = "qy:agenda_customiz:view";
    public static final String AGENDA_CUSTOMIZ_EDIT = "qy:agenda_customiz:edit";

    @Autowired
    private Agenda_customizService agenda_customizService;
    @Autowired
    private CodingruleUtils codingruleUtils;
    @Autowired
    private UserService userService;


    //列表页面
    @RequiresPermissions(value = AGENDA_CUSTOMIZ_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,Long meetingId) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("meetingId",meetingId);
        return "agenda_customiz/agenda_customizlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = AGENDA_CUSTOMIZ_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model , Long meetingId) {
        if (!StringUtils.isEmpty(id)) {
            Agenda_customiz agenda_customiz = agenda_customizService.fetchById(id);
            model.addAttribute("data", agenda_customiz);
            Conds conds = new Conds();
            conds.equal("delflag",0);
            conds.equal("customiz_id",id);
            User user = userService.fetchSearchByConds(conds);
            if(user!=null){
                model.addAttribute("username",user.getUsername());
            }
            Conds condss = new Conds();
            condss.equal("delflag",0);
            condss.equal("customiz_id",0);
            condss.notEqual("id",1);
            condss.notEqual("id",0);

            //Sort sort = new Sort("createtime",OrderType.DESC);
            List<User> list = userService.fetchoruserBycond(condss,Long.valueOf(id));
            if(list.size()>0){
                model.addAttribute("user",list);
            }

        }else{
            Conds condss = new Conds();
            condss.equal("delflag",0);
            condss.isNull("customiz_id");
            Sort sort = new Sort("createtime",OrderType.DESC);
            List<User> list = userService.fetchSearchByPage(condss,sort,0,0);
            if(list.size()>0){
                model.addAttribute("user",list);
            }
        }


        model.addAttribute("meetingId",meetingId);
        return "agenda_customiz/agenda_customizform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = AGENDA_CUSTOMIZ_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Agenda_customiz agenda_customiz, Model model, HttpServletRequest request,Long userid) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (agenda_customiz != null && agenda_customiz.getId() != null) {
                agenda_customiz.setUpdateBy(UserUtils.getUser().getId());
                Boolean flag = agenda_customizService.updateuser(agenda_customiz,userid);
                if(flag){
                    rtnJson.put("errorNo", 0);
                }
            } else {
                agenda_customiz.setNumber(codingruleUtils.getNumber(accountsId, Agenda_customiz.class.getName()));
                agenda_customiz.setAccountsId(accountsId);
                agenda_customiz.setDelFlag(false);
                agenda_customiz.setAccountsId(UserUtils.getmpaccounts(request));
                agenda_customiz.setCreateBy(UserUtils.getUser().getId());
                agenda_customiz.setUpdateBy(UserUtils.getUser().getId());
                boolean flag = agenda_customizService.addusercustomiz(agenda_customiz,userid);
                if(flag){
                    rtnJson.put("errorNo", 2);
                }

            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = AGENDA_CUSTOMIZ_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Agenda_customiz agenda_customiz, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(agenda_customiz.getCustomiz_name())) {
            conds.like("customiz_name", agenda_customiz.getCustomiz_name());
        }
        if(!StringUtils.isEmpty(agenda_customiz.getWorkshop_id())){
            conds.equal("workshop_id",agenda_customiz.getWorkshop_id());
        }
        Sort sort = new Sort("sort", OrderType.ASC);

        List<Agenda_customiz> list = agenda_customizService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = agenda_customizService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = AGENDA_CUSTOMIZ_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            agenda_customizService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
