package com.cftech.common.cancelitems.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 申请单详情
 *
 * @author faye
 * @date: 2019-08-19 09:45
 */
@Data
public class Cancelitems implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    private String number;
    /* 所属申请单 */
    private Long appform;
    /* 所申请商品ID */
    private Long appitem;
    @ExportConfig(value = "申请单号", width = 100)
    private String formNumber;
    /* 商品名称 */
    @ExportConfig(value = "物品名称", width = 100)
    private String itemname;
    /* 商品单价 */
    @ExportConfig(value = "物品单价", width = 100)
    private String price;
    /* 申请数量 */
    private Integer realityGrantCount;
    /* 发放数量 */
    @ExportConfig(value = "退库数量", width = 100)
    private Integer cancelCount;

    private Long grantId;

    /* 发放数量 */
    @ExportConfig(value = "退库时间", width = 100,dateFormat = "yyyy-MM-dd HH:mm")
    private Date cancelTime;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    @ExportConfig(value = "退库原因", width = 100)
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    /*申请规格*/
    @ExportConfig(value = "物品规格", width = 100)
    private String specifications;

    /*剩余库存*/
    private String authenticStock;

    /*申请人*/
    @ExportConfig(value = "申请人", width = 100)
    private String name;

    /*申请部门*/
    @ExportConfig(value = "申请部门", width = 100)
    private String departmentName;

    private String typeformName;

    private Integer managerGrantCount;

    public Cancelitems() {
        this.delFlag = false;
        this.status = "0";
    }

    public static void main(String[] args) {
        BigDecimal bigDecimal = new BigDecimal("5.95555");

        BigDecimal bigDecimal2 = new BigDecimal("6");
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
        bigDecimal3 = bigDecimal3.setScale(2,BigDecimal.ROUND_HALF_UP);
        System.out.println(bigDecimal3.toString());
    }

}