package com.cftech.activity.log.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.activity.log.model.OilLog;
import com.cftech.activity.log.service.OilLogService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * 机油大转盘活动记录表Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String EGGSLOG_VIEW = "qy:OilLog:view"
 * 查看:public static final String EGGSLOG_EDIT = "qy:OilLog:edit"
 * @author wuxf
 */
@Slf4j
@Controller
@RequestMapping("/a/activity/oilLog")
public class OilLogController {

    public static final String EGGSLOG_VIEW = "activity:oilLog:view";
    public static final String EGGSLOG_EDIT = "activity:oilLog:edit";

    @Autowired
    private OilLogService oilLogService;


    //列表页面
    @RequiresPermissions(value = EGGSLOG_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "oilLog/oilLoglist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = EGGSLOG_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            OilLog oilLog = oilLogService.fetchById(id);
            model.addAttribute("data", oilLog);
        }
        return "OilLog/OilLogform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = EGGSLOG_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(OilLog oilLog, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (oilLog != null && oilLog.getId() != null) {
                oilLog.setUpdateBy(UserUtils.getUser().getId());
                oilLogService.update(oilLog);
                rtnJson.put("errorNo", 0);
            } else {
                oilLog.setAccountsId(accountsId);
                oilLog.setDelFlag(false);
                oilLog.setAccountsId(UserUtils.getmpaccounts(request));
                oilLog.setCreateBy(UserUtils.getUser().getId());
                oilLog.setUpdateBy(UserUtils.getUser().getId());
                oilLogService.save(oilLog);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = EGGSLOG_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, OilLog oilLog, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(oilLog.getFrom())) {
            conds.like("from", oilLog.getFrom());
        }
        if (!StringUtils.isEmpty(oilLog.getActivityId())) {
            conds.equal("activity_id", oilLog.getActivityId());
        }
        if (!StringUtils.isEmpty(oilLog.getTitle())) {
            conds.like("title", oilLog.getTitle());
        }
        if (!StringUtils.isEmpty(oilLog.getOpenId())) {
            conds.like("open_id", oilLog.getOpenId());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<OilLog> list = oilLogService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = oilLogService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = EGGSLOG_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            oilLogService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
