/**
 * Created by liuling on 16/9/7.
 */

var dataUtils = (function() {
     //'use strict';
    /**
     * 输入日期,返回格式化后的字符串,类似java中的SimpleDateFormat
     * @param date
     * @param fmt
     * @returns {*}
     */
    var dateFormat = function(date, fmt){
        const o = {
            "M+": date.getMonth() + 1, //月份
            "d+": date.getDate(), //日
            "h+": date.getHours(), //小时
            "m+": date.getMinutes(), //分
            "s+": date.getSeconds(), //秒
            "q+": Math.floor((date.getMonth() + 3) / 3), //季度
            "S": date.getMilliseconds() //毫秒
        };
        if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (date.getFullYear() + "").substr(4 - RegExp.$1.length));
        for (var k in o)
            if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        return fmt;
    }
    return {
        dateFormat: dateFormat
    }
})();


