package com.cftech.workshop.speech.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.workshop.speech.model.Speech;
import com.cftech.workshop.speech.service.SpeechService;
import org.owasp.esapi.ESAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by byj on 2018/7/12.
 */
@RestController
@RequestMapping(value = "/mobile/auth/speech")
public class MobileSpeechController {

    @Autowired
    private SpeechService speechService;

    /**
     * 演讲嘉宾接口
     * @param meetingId 研讨会Id
     * @return
     */
    @RequestMapping(value = "getspeech",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getspeech(Long meetingId,int page,int pagesize,String memberUid,Long accountsId){
        JSONObject jsonObject = new JSONObject();
        Conds conds = new Conds();
        try {
            if(meetingId!=0){
                conds.equal("workshop_id",meetingId);
                conds.equal("del_flag",0);
            }
            Sort sort = new Sort("sort", OrderType.ASC);
            List<Speech> list = speechService.fetchSearchByPage(conds,sort,page*pagesize,pagesize);
            if(list!=null){
                for(Speech speech : list){
                    speech.setContent_speech(ESAPI.encoder().decodeForHTML(speech.getContent_speech()));
                    speech.setContent_speech_en(ESAPI.encoder().decodeForHTML(speech.getContent_speech_en()));
                    jsonObject.put("data",list);
                }

            }
            jsonObject.put("errorNo",0);
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }

    /**
     * 演讲嘉宾详情
     * @param id 演讲嘉宾iD
     * @return
     */
    @RequestMapping(value = "/getspeechdetails",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getspeechdetails(Long id, String memberUid, Long accountsId){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(id))){
               Speech speech = speechService.updatespeechclick(id,memberUid,accountsId);
                if(speech!=null){
                    speech.setContent_speech(ESAPI.encoder().decodeForHTML(speech.getContent_speech()));
                    speech.setContent_speech_en(ESAPI.encoder().decodeForHTML(speech.getContent_speech_en()));
                    jsonObject.put("data",speech);
                }
            }
            jsonObject.put("errorNo",0);
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

}
