package com.cftech.cms.exhibi_sample.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.cms.exhibi_sample.model.Exhibi_sample;
import com.cftech.cms.exhibi_sample.service.Exhibi_sampleService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.owasp.esapi.ESAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String EXHIBI_SAMPLE_VIEW = "qy:exhibi_sample:view"
 * 查看:public static final String EXHIBI_SAMPLE_EDIT = "qy:exhibi_sample:edit"
 *
 * @author byj
 * @date: 2018-09-06 17:19
 */
@Slf4j
@Controller
@RequestMapping("/a/exhibi_sample")
public class Exhibi_sampleController {

    public static final String EXHIBI_SAMPLE_VIEW = "qy:exhibi_sample:view";
    public static final String EXHIBI_SAMPLE_EDIT = "qy:exhibi_sample:edit";

    @Autowired
    private Exhibi_sampleService exhibi_sampleService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = EXHIBI_SAMPLE_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,String exhibi_id) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        if(!StringUtils.isEmpty(exhibi_id)){
            model.addAttribute("exhibi_id",exhibi_id);
        }
        return "exhibi_sample/exhibi_samplelist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = EXHIBI_SAMPLE_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model,String exhibi_id) {
        if (!StringUtils.isEmpty(id)) {
            Exhibi_sample exhibi_sample = exhibi_sampleService.fetchById(id);
            exhibi_sample.setContent_sample(ESAPI.encoder().decodeForHTML(exhibi_sample.getContent_sample()));
            exhibi_sample.setContent_sample_en(ESAPI.encoder().decodeForHTML(exhibi_sample.getContent_sample_en()));
            model.addAttribute("data", exhibi_sample);
        }
        model.addAttribute("exhibi_id",exhibi_id);
        return "exhibi_sample/exhibi_sampleform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = EXHIBI_SAMPLE_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Exhibi_sample exhibi_sample, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (exhibi_sample != null && exhibi_sample.getId() != null) {
                exhibi_sample.setUpdateBy(UserUtils.getUser().getId());
                exhibi_sampleService.update(exhibi_sample);
                rtnJson.put("errorNo", 0);
            } else {
                exhibi_sample.setNumber(codingruleUtils.getNumber(accountsId, Exhibi_sample.class.getName()));
                exhibi_sample.setAccountsId(accountsId);
                exhibi_sample.setDelFlag(false);
                exhibi_sample.setAccountsId(UserUtils.getmpaccounts(request));
                exhibi_sample.setCreateBy(UserUtils.getUser().getId());
                exhibi_sample.setUpdateBy(UserUtils.getUser().getId());
                exhibi_sampleService.save(exhibi_sample);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = EXHIBI_SAMPLE_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Exhibi_sample exhibi_sample, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(exhibi_sample.getNumber())) {
            conds.like("number", exhibi_sample.getNumber());
        }
        if (!StringUtils.isEmpty(exhibi_sample.getSample_title())) {
            conds.like("sample_title", exhibi_sample.getSample_title());
        }
        if(!StringUtils.isEmpty(exhibi_sample.getExhibi_id())){
            conds.equal("exhibi_id",exhibi_sample.getExhibi_id());
        }
        Sort sort = new Sort("sort", OrderType.ASC);

        List<Exhibi_sample> list = exhibi_sampleService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = exhibi_sampleService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = EXHIBI_SAMPLE_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            exhibi_sampleService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
