package com.cftech.waybill.service;

import com.alibaba.fastjson.JSONObject;
import com.cftech.waybill.model.Waybill;
import com.cftech.core.generic.GenericService;

import javax.servlet.http.HttpServletRequest;

/**
 * 顺丰物流运单Service
 *
 * @author Strive
 * @date: 2020-10-21 15:04boolean
 */
public interface WaybillService extends GenericService<Waybill> {

    /**
     * 查询物流单实体(连查)
     * @param id
     * @return
     */
    Waybill fetchByWayBillId(String id);

    /**
     * 调用顺丰下订单接口
     * @param orderId
     */
    JSONObject orderSendOutForWaybill(HttpServletRequest request, Long orderId);

    /**
     * 调用顺分sdk打印面单
     * @param request
     * @param orderId
     * @return
     */
    JSONObject orderPrinterBill(HttpServletRequest request, Long orderId);
}
