var list = (function () {
    'use strict';
    var List = function (params) {
        var p = this;
        p.params = {
            appid: '',
            id: '',
            accountsId: '',
            cfApp: null,
            devMode: false,
            localStorage: [],
            dataApi: G.baseUri() + '/mobile/auth/appform/getAppFormList',
            vt: ''
        };
        for (var param in params) {
            p.params[param] = params[param];
        }
        var cfApp = p.params.cfApp;

        if (p.params.devMode) {

        }
        p.pageSize = 10;
        p.pageNo = 0;
        p.channelData = [];
        /**
         * 判断app字段
         * @returns 是否app有值
         */
        var validAppField = function () {
            if (!p.params.appid || p.params.appid == '') {
                return false;
            } else {
                return true;
            }
        };

        /**
         * 确认初始化的app 和tokenId 两个值是否都存在
         * 如果不存在则获取一次,获取不到则初始化失败
         * @returns 初始化基础字段是否成功
         */
        var initBaseFields = function () {
            if (!validAppField()) {
                p.params.appid = cfApp.getQueryString('appid');
                p.params.id = cfApp.getQueryString('id');
                p.params.accountsId = cfApp.getQueryString('accountsId');
            }



            //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
            if (!validAppField()) {
                if (p.params.cfApp) {
                    p.params.appid = cfApp.getAppId();
                    //p.params.tokenId = cfApp.getTokenId();
                }
            }
            p.empInfo = cfApp.getMpInfo();
            p.params.accountsId = p.empInfo.accountsId;
            return validAppField();
        };

        /**
         * 初始化组件
         * @returns {boolean}
         */


        p.init = function () {
            if (initBaseFields()) {
                log();
                loadData();
                next();
                initDate(dateDayFormat());
                dateEvent();
                return true;
            } else {
                return false;
            }

        };

        var log = function () {
            var formdata = {
                openid: p.empInfo.openId,
                module: "展厅申请",
                modulename: "预约列表",
                keyword: "预约列表",
                keywordid: '',
                vt: new Date().getTime(),
                appid: cfApp.getQueryString('appid'),
                url: location.href
            };
            G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


            });
        }

        var dateEvent = function(){
            $("#calendar").on("click",".calendar-day .week-day li",function(){
                var date = $(this).find("input").val();
                initDate(date);
            })
        }

        var dateFormat = function(timestamp){
            var time = new Date(timestamp)    //先将时间戳转为Date对象，然后才能使用Date的方法
            var year = time.getFullYear(),
                month = time.getMonth() + 1 ,  //月份是从0开始的
                day = time.getDate(),
                hour = time.getHours(),
                minute = time.getMinutes(),
                second = time.getSeconds()
            //add0()方法在后面定义
            var s = year+'-'+add0(month)+'-'+ add0(day)+' '+add0(hour)+':'+add0(minute)+':'+add0(second);
            console.log(s);
            return  s

        }
        var dateDayFormat = function(){
            var time = new Date()    //先将时间戳转为Date对象，然后才能使用Date的方法
            var year = time.getFullYear(),
                month = time.getMonth() + 1 ,  //月份是从0开始的
                day = time.getDate(),
                hour = time.getHours(),
                minute = time.getMinutes(),
                second = time.getSeconds()
            //add0()方法在后面定义
            var s = year+'-'+add0(month)+'-'+ add0(day);
            console.log(s);
            return  s

        }

        var add0 = function(m){
            return m < 10 ? '0' + m: m
        }


        var initDate = function(date){

            var formdata = {
                "data":date
            }
            var array = [];

            $.showLoading("数据加载中");
            G.ajax('get', p.params.dataApi, formdata, function (retdata) {
                $.hideLoading();
                if(retdata.errorNo=='0'){
                    retdata = retdata.datas;
                   for(var i =0;i<retdata.length;i++){
                       var obj = {};
                       obj.title="申请人:"+retdata[i].name;
                       obj.start=dateFormat(retdata[i].reservationBeginTime);
                       obj.end=dateFormat(retdata[i].reservationEndTime);
                       obj.color = "#00893D";
                       array.push(obj);
                   }
                   console.log(JSON.stringify(array));
                    $("#calendar_detail").html("");
                    var initialLocaleCode = 'zh-cn';
                    var calendarEl = document.getElementById('calendar_detail');
                    var calendar = new FullCalendar.Calendar(calendarEl, {
                        plugins: ['timeGrid'],
                        timezone:"Asia/Shanghai",
                        defaultDate: date,
                        header:false,
                        editable:false,//不可编辑
                        allDaySlot: false,
                        columnHeader: false,
                        minTime: '09:00:00',
                        maxTime: '19:00:00',
                        slotLabelFormat: {
                            hour: '2-digit',
                            minute: '2-digit',
                            hour12: false,
                        },
                        eventStartEditable:false,
                        displayEventEnd: true,//总是显示结束时间
                        disableDragging:true,//不可拖动
                        defaultView:'timeGridDay',
                        diableResizing:true,//不可改变大小
                        locale: 'zh-cn',
                        height : window.innerHeight-20,
                        windowResize: function(view) {
                            $('#calendar_detail').fullCalendar('option', 'height', window.innerHeight-20);
                        },
                        timeFormat: {
                            agenda: 'H(:mm)' //h:mm{ - h:mm}'
                        },axisFormat: 'H(:mm)', //,'h(:mm)tt',
                        buttonIcons: false, // show the prev/next text
                        weekNumbers: true,
                        navLinks: true, // can click day/week names to navigate views
                        eventLimit: true, // allow "more" link when too many events
                        events:function(obj, callback){
                            console.log("开始时间："+obj.startStr);
                            console.log("结束时间："+obj.endStr);
                            callback(array);
                        }
                    });
                    calendar.render();
                }
            })

        }



        var next = function () {
            $("#Apply").click(function(){
                location.href="./form.html?appid="+p.params.appid;
            })
        }
        var loadData = function () {
        }


    };

    return List;
})();
