package com.cftech.workshop.speech.service.impl;

import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Sort;
import com.cftech.sys.security.UserUtils;
import com.cftech.workshop.sample.model.Sample;
import com.cftech.workshop.speech.dao.SpeechclickMapper;
import com.cftech.workshop.speech.model.Speech;
import com.cftech.workshop.speech.dao.SpeechMapper;
import com.cftech.workshop.speech.model.Speechclick;
import com.cftech.workshop.speech.service.SpeechService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2018-06-29 14:18
 */
@Service("speechService")
public class SpeechServiceImpl extends GenericServiceImpl<Speech> implements SpeechService {

    @Autowired
    @Qualifier("speechMapper")
    private SpeechMapper speechMapper;

    @Autowired
    private SpeechclickMapper speechclickMapper;

    @Autowired
    private CodingruleUtils codingruleUtils;

    @Override
    public GenericDao<Speech> getGenericMapper() {
        return speechMapper;
    }

    /**
     * 更新演讲嘉宾的点击量 并且添加查看人的不重复信息
     * @param id 演讲嘉宾实体ID
     * @param memberUid 会员名称
     * @param accountsId 服务号ID
     * @return
     */
    @Override
    public Speech updatespeechclick(Long id, String memberUid, Long accountsId){
        Speech speech = null;
        if(id!=0){
            speech = speechMapper.fetchById(id);
            speech.setClicks(speech.getClicks()+1);
            speechMapper.update(speech);
        }
        Map param = new HashMap();
        Conds conds = new Conds();
        conds.equal("member_uid",memberUid);
        conds.equal("speech_id",id);
        Sort sort = new Sort("create_time", OrderType.DESC);
        param.put("conds",conds);
        param.put("sort",sort);
        List<Speechclick> list = speechclickMapper.fetchSearchByPage(param);
        if(list.size()==0){
            Speechclick speechclick = new Speechclick();
            speechclick.setNumber(codingruleUtils.getNumber(accountsId, Sample.class.getName()));
            speechclick.setAccountsId(accountsId);
            speechclick.setDelFlag(false);
            speechclick.setAccountsId(accountsId);
            speechclick.setCreateBy(UserUtils.getUser().getId());
            speechclick.setUpdateBy(UserUtils.getUser().getId());
            speechclick.setMember_uid(memberUid);
            speechclick.setSpeech_id(id);
            speechclickMapper.save(speechclick);
        }
        return speech;
    }

}