package com.cftech.showroom.svideo.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.util.SystemConfig;
import com.cftech.core.util.UploadUtils;
import com.cftech.cos.config.cosconfig.model.Cosconfig;
import com.cftech.cos.config.cosconfig.service.CosconfigService;
import com.cftech.cos.core.CosService;
import com.cftech.cos.uploader.CosFileUploader;
import com.cftech.showroom.svideo.model.Svideo;
import com.cftech.showroom.svideo.service.SvideoService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.owasp.esapi.ESAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;


/**
 * 展厅申请视频图文Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String SVIDEO_VIEW = "qy:svideo:view"
 * 查看:public static final String SVIDEO_EDIT = "qy:svideo:edit"
 *
 * @author lisw
 * @date: 2019-07-31 14:58
 */
@Slf4j
@Controller
@RequestMapping("/a/svideo")
public class SvideoController {

    public static final String SVIDEO_VIEW = "qy:svideo:view";
    public static final String SVIDEO_EDIT = "qy:svideo:edit";

    @Autowired
    private SvideoService svideoService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = SVIDEO_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "svideo/svideolist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = SVIDEO_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        Conds conds = new Conds();
        conds.equal("status","0");
        Svideo svideo = svideoService.fetchSearchByConds(conds);
        svideo.setPersonContent(ESAPI.encoder().decodeForHTML(svideo.getPersonContent()));
        model.addAttribute("data", svideo);
        return "svideo/svideoform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = SVIDEO_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Svideo svideo, Model model, HttpServletRequest request,MultipartFile videoFileAddress,Long cosconfigId) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        Map<String,Object> jsonObject=null;
        try {
            if(videoFileAddress!=null){
                jsonObject= UploadUtils.uploadImageFilesByQcloudInputStearm(request, "newRecommend",videoFileAddress,"/gogi/newReCommend/");
                String url= jsonObject.get("fileUrl")==null?"":jsonObject.get("fileUrl").toString();
                svideo.setName(url);
            }

            //删除视频
            if(StringUtils.isEmpty(svideo.getName()) && videoFileAddress==null){
                svideo.setName("");
            }
            if (svideo != null && svideo.getId() != null) {
                svideo.setUpdateBy(UserUtils.getUser().getId());
                svideoService.update(svideo);
                rtnJson.put("errorNo", 0);
            } else {
                svideo.setNumber(codingruleUtils.getNumber(accountsId, Svideo.class.getName()));
                svideo.setAccountsId(accountsId);
                svideo.setDelFlag(false);
                svideo.setAccountsId(UserUtils.getmpaccounts(request));
                svideo.setCreateBy(UserUtils.getUser().getId());
                svideo.setUpdateBy(UserUtils.getUser().getId());
                svideoService.save(svideo);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            log.error(e.getMessage());
        }


        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = SVIDEO_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Svideo svideo, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(svideo.getNumber())) {
            conds.like("number", svideo.getNumber());
        }
        if (!StringUtils.isEmpty(svideo.getName())) {
            conds.like("name", svideo.getName());
        }
        if (!StringUtils.isEmpty(svideo.getPersonContent())) {
            conds.equal("person_content", svideo.getPersonContent());
        }
        if (!StringUtils.isEmpty(svideo.getSpeechContent())) {
            conds.like("speech_content", svideo.getSpeechContent());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Svideo> list = svideoService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = svideoService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = SVIDEO_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            svideoService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
