package com.cftech.base.org.dao;

import com.cftech.base.org.model.Qyuser;
import com.cftech.base.org.model.vo.QyOrgUserVO;
import com.cftech.base.org.model.vo.QyuserVO;
import com.cftech.core.generic.GenericDao;

import java.util.List;
import java.util.Map;

/**
 * qyuserMapper
 * Created by Neil 14/02/2017.
 */
public interface QyuserMapper extends GenericDao<Qyuser> {

    List<QyuserVO> fetchSearchVOByPage(Map<String, Object> params);

    void batchUpdate(Map<String, Object> params);

    /**
     * 更新门店信息
     * @param params
     */
    void updateStoreInfo(Map<String, Object> params);

    /**
     * 根据人员ID查询所有下属人员信息
     * @param params
     * @return
     */
    List<QyuserVO> getSubordinateUser(Map<String, Object> params);
    
    /**
     * 根据人员ID查询所有下属组织及人员
     * @param params
     * @return
     */
    List<QyOrgUserVO> getOrgSubordinateUser(Map<String, Object> params);

    void appendTagids(Map<String, Object> params);
    
    
    /**
     * 根据所选部门查询出部门下面的所有下级人员
     * @param params
     * @return
     */
    List<Qyuser> getOrgUserList(Map<String, Object> params);

    /**
     * 根据TagIds 获取人员列表
     *
     * @param params
     * @return
     */
    List<Qyuser> findUsersByTagIds(Map<String, Object> params);



    
    /**
     *批量为终端更改终端负责人账号 
     */
    Integer updateUserTerminal(Map<String, Object> params);


    List<Qyuser> getLogInfo(Map<String, Object> params);

    /**
     * 获取轮询的人员（药师、医生）且通过峰值排序
     * @return
     */
    List<Qyuser> fetchPollingData(String type);

    /**
     * 更新未超过峰值/超过峰值，分配咨询单数量
     * @param user
     * @return
     */
    boolean updateAssigned(Qyuser user);
}
